/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.action;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Map;
import org.hawkular.alerts.api.model.event.Event;
import org.hawkular.alerts.api.model.event.Thin;

public class Action
implements Serializable {
    @JsonInclude
    private String tenantId;
    @JsonInclude
    private String actionPlugin;
    @JsonInclude
    private String actionId;
    @JsonInclude
    private String eventId;
    @JsonInclude
    private long ctime;
    @Thin
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Event event;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, String> properties;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String result;

    public Action() {
    }

    public Action(String tenantId, String actionPlugin, String actionId, Event event) {
        this.tenantId = tenantId;
        this.actionPlugin = actionPlugin;
        this.actionId = actionId;
        this.event = event;
        if (event != null) {
            this.eventId = event.getId();
        }
        this.ctime = System.currentTimeMillis();
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public String getActionPlugin() {
        return this.actionPlugin;
    }

    public void setActionPlugin(String actionPlugin) {
        this.actionPlugin = actionPlugin;
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public long getCtime() {
        return this.ctime;
    }

    public void setCtime(long ctime) {
        this.ctime = ctime;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Action action = (Action)o;
        if (this.ctime != action.ctime) {
            return false;
        }
        if (this.tenantId != null ? !this.tenantId.equals(action.tenantId) : action.tenantId != null) {
            return false;
        }
        if (this.actionPlugin != null ? !this.actionPlugin.equals(action.actionPlugin) : action.actionPlugin != null) {
            return false;
        }
        if (this.actionId != null ? !this.actionId.equals(action.actionId) : action.actionId != null) {
            return false;
        }
        if (this.eventId != null ? !this.eventId.equals(action.eventId) : action.eventId != null) {
            return false;
        }
        if (this.properties != null ? !this.properties.equals(action.properties) : action.properties != null) {
            return false;
        }
        return !(this.result == null ? action.result != null : !this.result.equals(action.result));
    }

    public int hashCode() {
        int result1 = this.tenantId != null ? this.tenantId.hashCode() : 0;
        result1 = 31 * result1 + (this.actionPlugin != null ? this.actionPlugin.hashCode() : 0);
        result1 = 31 * result1 + (this.actionId != null ? this.actionId.hashCode() : 0);
        result1 = 31 * result1 + (this.eventId != null ? this.eventId.hashCode() : 0);
        result1 = 31 * result1 + (int)(this.ctime ^ this.ctime >>> 32);
        result1 = 31 * result1 + (this.properties != null ? this.properties.hashCode() : 0);
        result1 = 31 * result1 + (this.result != null ? this.result.hashCode() : 0);
        return result1;
    }

    public String toString() {
        return "Action{tenantId='" + this.tenantId + '\'' + ", actionPlugin='" + this.actionPlugin + '\'' + ", actionId='" + this.actionId + '\'' + ", eventId='" + this.eventId + '\'' + ", ctime=" + this.ctime + ", event=" + this.event + ", properties=" + this.properties + ", result='" + this.result + '\'' + '}';
    }
}

