/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.condition;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.event.Event;
import org.hawkular.alerts.api.model.trigger.Mode;

public class EventCondition
extends Condition {
    @JsonInclude
    private String dataId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String expression;
    private static Pattern cleanComma = Pattern.compile("\\\\,");
    private static final String TENANT_ID = "tenantId";
    private static final String ID = "id";
    private static final String CTIME = "ctime";
    private static final String TEXT = "text";
    private static final String CATEGORY = "category";
    private static final String TAGS = "tags.";
    private static final String EQ = "==";
    private static final String NON_EQ = "!=";
    private static final String STARTS = "starts";
    private static final String ENDS = "ends";
    private static final String CONTAINS = "contains";
    private static final String MATCHES = "matches";
    private static final String LT = "<";
    private static final String LTE = "<=";
    private static final String GT = ">";
    private static final String GTE = ">=";

    public EventCondition() {
        this("DefaultId", Mode.FIRING, 1, 1, null, null);
    }

    public EventCondition(String triggerId, String dataId) {
        this(triggerId, Mode.FIRING, 1, 1, dataId, null);
    }

    public EventCondition(String triggerId, String dataId, String expression) {
        this(triggerId, Mode.FIRING, 1, 1, dataId, expression);
    }

    public EventCondition(String triggerId, Mode triggerMode, String dataId) {
        this(triggerId, triggerMode, 1, 1, dataId, null);
    }

    public EventCondition(String triggerId, Mode triggerMode, String dataId, String expression) {
        this(triggerId, triggerMode, 1, 1, dataId, expression);
    }

    public EventCondition(String triggerId, int conditionSetSize, int conditionSetIndex, String dataId) {
        this(triggerId, Mode.FIRING, conditionSetSize, conditionSetIndex, dataId, null);
    }

    public EventCondition(String triggerId, int conditionSetSize, int conditionSetIndex, String dataId, String expression) {
        this(triggerId, Mode.FIRING, conditionSetSize, conditionSetIndex, dataId, expression);
    }

    public EventCondition(String triggerId, Mode triggerMode, int conditionSetSize, int conditionSetIndex, String dataId) {
        this(triggerId, triggerMode, conditionSetSize, conditionSetIndex, dataId, null);
    }

    public EventCondition(String triggerId, Mode triggerMode, int conditionSetSize, int conditionSetIndex, String dataId, String expression) {
        super(triggerId, triggerMode, conditionSetSize, conditionSetIndex, Condition.Type.EVENT);
        this.dataId = dataId;
        this.expression = expression;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public String getLog(Event value) {
        return this.triggerId + " " + this.dataId + " : " + value + " " + this.expression;
    }

    @Override
    public String getDataId() {
        return this.dataId;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public boolean match(Event value) {
        if (null == value) {
            return false;
        }
        if (null == this.expression || this.expression.isEmpty()) {
            return true;
        }
        ArrayList<String> expressions = new ArrayList<String>();
        int j = 0;
        for (int i = 0; i < this.expression.length(); ++i) {
            if (this.expression.charAt(i) != ',' || i != 0 && (i <= 0 || this.expression.charAt(i - 1) == '\\')) continue;
            expressions.add(cleanComma.matcher(this.expression.substring(j, i).trim()).replaceAll(","));
            j = i + 1;
        }
        expressions.add(cleanComma.matcher(this.expression.substring(j).trim()).replaceAll(","));
        for (String expression : expressions) {
            if (this.processExpression(expression, value)) continue;
            return false;
        }
        return true;
    }

    private boolean processExpression(String expression, Event value) {
        if (null == expression || expression.isEmpty() || null == value) {
            return false;
        }
        String[] tokens = expression.split(" ");
        if (tokens.length < 3) {
            return false;
        }
        String eventField = tokens[0];
        String operator = tokens[1];
        String constant = tokens[2];
        for (int i = 3; i < tokens.length; ++i) {
            constant = constant + " ";
            constant = constant + tokens[i];
        }
        String sEventValue = null;
        Long lEventValue = null;
        String sConstantValue = null;
        Double dConstantValue = null;
        if (eventField == null || eventField.isEmpty()) {
            return false;
        }
        if (TENANT_ID.equals(eventField)) {
            sEventValue = value.getTenantId();
        } else if (ID.equals(eventField)) {
            sEventValue = value.getId();
        } else if (CTIME.equals(eventField)) {
            lEventValue = value.getCtime();
        } else if (TEXT.equals(eventField)) {
            sEventValue = value.getText();
        } else if (CATEGORY.equals(eventField)) {
            sEventValue = value.getCategory();
        } else if (eventField.startsWith(TAGS)) {
            String key = eventField.substring(5);
            sEventValue = value.getTags().get(key);
        }
        if (sEventValue == null && lEventValue == null) {
            return false;
        }
        if (constant == null) {
            return false;
        }
        int constantLength = constant.length();
        if (constant.charAt(0) == '\'' && constant.charAt(constantLength - 1) == '\'') {
            sConstantValue = constant.substring(1, constantLength - 1);
        } else {
            if (constant.charAt(0) == '\'' && constant.charAt(constantLength - 1) != '\'') {
                return false;
            }
            if (constant.charAt(0) != '\'' && constant.charAt(constantLength - 1) == '\'') {
                return false;
            }
            dConstantValue = Double.valueOf(constant);
        }
        if (EQ.equals(operator)) {
            if (sEventValue != null && sConstantValue != null) {
                return sEventValue.equals(sConstantValue);
            }
            if (lEventValue != null && dConstantValue != null) {
                return (double)lEventValue.longValue() == dConstantValue;
            }
            return false;
        }
        if (NON_EQ.equals(operator)) {
            if (sEventValue != null && sConstantValue != null) {
                return !sEventValue.equals(sConstantValue);
            }
            if (lEventValue != null && dConstantValue != null) {
                return (double)lEventValue.longValue() != dConstantValue;
            }
            return false;
        }
        if (STARTS.equals(operator)) {
            if (sEventValue != null && sConstantValue != null) {
                return sEventValue.startsWith(sConstantValue);
            }
            return false;
        }
        if (ENDS.equals(operator)) {
            if (sEventValue != null && sConstantValue != null) {
                return sEventValue.endsWith(sConstantValue);
            }
            return false;
        }
        if (CONTAINS.equals(operator)) {
            if (sEventValue != null && sConstantValue != null) {
                return sEventValue.contains(sConstantValue);
            }
            return false;
        }
        if (MATCHES.equals(operator)) {
            if (sEventValue != null && sConstantValue != null) {
                return sEventValue.matches(sConstantValue);
            }
            return false;
        }
        if (GT.equals(operator)) {
            Double dEventValue = lEventValue != null ? Double.valueOf(lEventValue.doubleValue()) : null;
            Double d = dEventValue = sEventValue != null ? Double.valueOf(sEventValue) : dEventValue;
            if (dEventValue != null && dConstantValue != null) {
                return dEventValue > dConstantValue;
            }
            return false;
        }
        if (GTE.equals(operator)) {
            Double dEventValue = lEventValue != null ? Double.valueOf(lEventValue.doubleValue()) : null;
            Double d = dEventValue = sEventValue != null ? Double.valueOf(sEventValue) : dEventValue;
            if (dEventValue != null && dConstantValue != null) {
                return dEventValue >= dConstantValue;
            }
            return false;
        }
        if (LT.equals(operator)) {
            Double dEventValue = lEventValue != null ? Double.valueOf(lEventValue.doubleValue()) : null;
            Double d = dEventValue = sEventValue != null ? Double.valueOf(sEventValue) : dEventValue;
            if (dEventValue != null && dConstantValue != null) {
                return dEventValue < dConstantValue;
            }
            return false;
        }
        if (LTE.equals(operator)) {
            Double dEventValue = lEventValue != null ? Double.valueOf(lEventValue.doubleValue()) : null;
            Double d = dEventValue = sEventValue != null ? Double.valueOf(sEventValue) : dEventValue;
            if (dEventValue != null && dConstantValue != null) {
                return dEventValue <= dConstantValue;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EventCondition that = (EventCondition)o;
        return !(this.expression == null ? that.expression != null : !this.expression.equals(that.expression));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.expression != null ? this.expression.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "EventCondition{dataId='" + this.dataId + '\'' + ",expression='" + this.expression + '\'' + '}';
    }
}

