/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.condition;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.ConditionEval;
import org.hawkular.alerts.api.model.condition.RateCondition;
import org.hawkular.alerts.api.model.data.Data;

public class RateConditionEval
extends ConditionEval {
    private static final long serialVersionUID = 1L;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private RateCondition condition;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Double value;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Double previousValue;
    @JsonInclude
    private long time;
    @JsonInclude
    private long previousTime;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Double rate;

    public RateConditionEval() {
        super(Condition.Type.RATE, false, 0L, null);
        this.value = Double.NaN;
        this.previousValue = Double.NaN;
        this.time = 0L;
        this.previousTime = 0L;
        this.rate = Double.NaN;
    }

    public RateConditionEval(RateCondition condition, Data data, Data previousData) {
        super(Condition.Type.RATE, condition.match(data.getTimestamp(), Double.valueOf(data.getValue()), previousData.getTimestamp(), Double.valueOf(previousData.getValue())), data.getTimestamp(), data.getContext());
        this.condition = condition;
        this.time = data.getTimestamp();
        this.value = Double.valueOf(data.getValue());
        this.previousTime = previousData.getTimestamp();
        this.previousValue = Double.valueOf(previousData.getValue());
        this.rate = condition.getRate(this.time, this.value, this.previousTime, this.previousValue);
    }

    public RateCondition getCondition() {
        return this.condition;
    }

    public void setCondition(RateCondition condition) {
        this.condition = condition;
    }

    public Double getValue() {
        return this.value;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public Double getPreviousValue() {
        return this.previousValue;
    }

    public void setPreviousValue(Double previousValue) {
        this.previousValue = previousValue;
    }

    public long getPreviousTime() {
        return this.previousTime;
    }

    public void setPreviousTime(long previousTime) {
        this.previousTime = previousTime;
    }

    public Double getRate() {
        return this.rate;
    }

    public void setRate(Double rate) {
        this.rate = rate;
    }

    @Override
    public String getTriggerId() {
        return this.condition.getTriggerId();
    }

    @Override
    public int getConditionSetSize() {
        return this.condition.getConditionSetSize();
    }

    @Override
    public int getConditionSetIndex() {
        return this.condition.getConditionSetIndex();
    }

    @Override
    public String getLog() {
        return this.condition.getLog(this.time, this.value, this.previousTime, this.previousValue) + ", evalTimestamp=" + this.evalTimestamp + ", dataTimestamp=" + this.dataTimestamp;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.condition == null ? 0 : this.condition.hashCode());
        result = 31 * result + (int)(this.previousTime ^ this.previousTime >>> 32);
        result = 31 * result + (this.previousValue == null ? 0 : this.previousValue.hashCode());
        result = 31 * result + (int)(this.time ^ this.time >>> 32);
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RateConditionEval other = (RateConditionEval)obj;
        if (this.condition == null ? other.condition != null : !this.condition.equals(other.condition)) {
            return false;
        }
        if (this.previousTime != other.previousTime) {
            return false;
        }
        if (this.previousValue == null ? other.previousValue != null : !this.previousValue.equals(other.previousValue)) {
            return false;
        }
        if (this.time != other.time) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "RateConditionEval [condition=" + this.condition + ", value=" + this.value + ", previousValue=" + this.previousValue + ", time=" + this.time + ", previousTime=" + this.previousTime + ", match=" + this.match + ", evalTimestamp=" + this.evalTimestamp + "]";
    }
}

