/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.condition;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.trigger.Mode;

public class StringCondition
extends Condition {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String dataId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Operator operator;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String pattern;
    @JsonInclude
    private boolean ignoreCase;

    public StringCondition() {
        this("DefaultId", 1, 1, null, null, null, false);
    }

    public StringCondition(String triggerId, String dataId, Operator operator, String pattern, boolean ignoreCase) {
        this(triggerId, Mode.FIRING, 1, 1, dataId, operator, pattern, ignoreCase);
    }

    public StringCondition(String triggerId, Mode triggerMode, String dataId, Operator operator, String pattern, boolean ignoreCase) {
        this(triggerId, triggerMode, 1, 1, dataId, operator, pattern, ignoreCase);
    }

    public StringCondition(String triggerId, int conditionSetSize, int conditionSetIndex, String dataId, Operator operator, String pattern, boolean ignoreCase) {
        this(triggerId, Mode.FIRING, conditionSetSize, conditionSetIndex, dataId, operator, pattern, ignoreCase);
    }

    public StringCondition(String triggerId, Mode triggerMode, int conditionSetSize, int conditionSetIndex, String dataId, Operator operator, String pattern, boolean ignoreCase) {
        super(triggerId, triggerMode, conditionSetSize, conditionSetIndex, Condition.Type.STRING);
        this.dataId = dataId;
        this.operator = operator;
        this.pattern = pattern;
        this.ignoreCase = ignoreCase;
    }

    @Override
    public String getDataId() {
        return this.dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getLog(String value) {
        return this.triggerId + " : " + value + " " + this.operator.name() + " " + this.pattern + " " + "ignoreCase=" + this.ignoreCase;
    }

    public boolean match(String value) {
        if (this.ignoreCase && this.operator != Operator.MATCH) {
            this.pattern = this.pattern.toLowerCase();
            value = value.toLowerCase();
        }
        switch (this.operator) {
            case EQUAL: {
                return value.equals(this.pattern);
            }
            case NOT_EQUAL: {
                return !value.equals(this.pattern);
            }
            case ENDS_WITH: {
                return value.endsWith(this.pattern);
            }
            case STARTS_WITH: {
                return value.startsWith(this.pattern);
            }
            case CONTAINS: {
                return value.contains(this.pattern);
            }
            case MATCH: {
                return value.matches(this.ignoreCase ? "(?i)" + this.pattern : this.pattern);
            }
        }
        throw new IllegalStateException("Unknown operator: " + this.operator.name());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StringCondition that = (StringCondition)o;
        if (this.ignoreCase != that.ignoreCase) {
            return false;
        }
        if (this.dataId != null ? !this.dataId.equals(that.dataId) : that.dataId != null) {
            return false;
        }
        if (this.operator != that.operator) {
            return false;
        }
        return !(this.pattern != null ? !this.pattern.equals(that.pattern) : that.pattern != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.dataId != null ? this.dataId.hashCode() : 0);
        result = 31 * result + (this.operator != null ? this.operator.hashCode() : 0);
        result = 31 * result + (this.pattern != null ? this.pattern.hashCode() : 0);
        result = 31 * result + (this.ignoreCase ? 1 : 0);
        return result;
    }

    @Override
    public String toString() {
        return "StringCondition [triggerId='" + this.triggerId + "', " + "triggerMode=" + (Object)((Object)this.triggerMode) + ", " + "dataId=" + (this.dataId == null ? null : '\'' + this.dataId + '\'') + ", " + "operator=" + (this.operator == null ? null : '\'' + this.operator.toString() + '\'') + ", " + "pattern=" + (this.pattern == null ? null : '\'' + this.pattern + '\'') + ", " + "ignoreCase=" + this.ignoreCase + "]";
    }

    public static enum Operator {
        EQUAL,
        NOT_EQUAL,
        STARTS_WITH,
        ENDS_WITH,
        CONTAINS,
        MATCH;

    }
}

