/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.event;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.hawkular.alerts.api.model.Severity;
import org.hawkular.alerts.api.model.condition.ConditionEval;
import org.hawkular.alerts.api.model.dampening.Dampening;
import org.hawkular.alerts.api.model.event.Event;
import org.hawkular.alerts.api.model.event.EventType;
import org.hawkular.alerts.api.model.event.Thin;
import org.hawkular.alerts.api.model.trigger.Trigger;

public class Alert
extends Event {
    @JsonInclude
    private Severity severity;
    @JsonInclude
    private Status status;
    @JsonInclude
    private long ackTime;
    @JsonInclude
    private String ackBy;
    @JsonInclude
    private long resolvedTime;
    @JsonInclude
    private String resolvedBy;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<Note> notes;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Thin
    private List<Set<ConditionEval>> resolvedEvalSets;

    public Alert() {
        this.eventType = EventType.ALERT.name();
        this.status = Status.OPEN;
    }

    public Alert(String tenantId, Trigger trigger, List<Set<ConditionEval>> evalSets) {
        this(tenantId, trigger, null, evalSets);
    }

    public Alert(String tenantId, Trigger trigger, Dampening dampening, List<Set<ConditionEval>> evalSets) {
        super(tenantId, trigger, dampening, evalSets);
        this.status = Status.OPEN;
        this.severity = trigger.getSeverity();
        this.eventType = EventType.ALERT.name();
    }

    @JsonIgnore
    public String getAlertId() {
        return this.id;
    }

    public void setAlertId(String alertId) {
        this.id = alertId;
    }

    @JsonIgnore
    public String getTriggerId() {
        return this.getTrigger().getId();
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public long getAckTime() {
        return this.ackTime;
    }

    public void setAckTime(long ackTime) {
        this.ackTime = ackTime;
    }

    public String getAckBy() {
        return this.ackBy;
    }

    public void setAckBy(String ackBy) {
        this.ackBy = ackBy;
    }

    public long getResolvedTime() {
        return this.resolvedTime;
    }

    public void setResolvedTime(long resolvedTime) {
        this.resolvedTime = resolvedTime;
    }

    public String getResolvedBy() {
        return this.resolvedBy;
    }

    public void setResolvedBy(String resolvedBy) {
        this.resolvedBy = resolvedBy;
    }

    public List<Set<ConditionEval>> getResolvedEvalSets() {
        return this.resolvedEvalSets;
    }

    public void setResolvedEvalSets(List<Set<ConditionEval>> resolvedEvalSets) {
        this.resolvedEvalSets = resolvedEvalSets;
    }

    public List<Note> getNotes() {
        if (null == this.notes) {
            this.notes = new ArrayList<Note>();
        }
        return this.notes;
    }

    public void setNotes(List<Note> notes) {
        this.notes = notes;
    }

    public void addNote(String user, String text) {
        if (user == null || text == null) {
            throw new IllegalArgumentException("Note must have non-null user and text");
        }
        this.getNotes().add(new Note(user, text));
    }

    @Override
    public String toString() {
        return "Alert [alertId=" + this.id + ", status=" + (Object)((Object)this.status) + ", ackTime=" + this.ackTime + ", ackBy=" + this.ackBy + ", resolvedTime=" + this.resolvedTime + ", resolvedBy=" + this.resolvedBy + ", context=" + this.getContext() + "]";
    }

    public static class Note {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private String user;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private long ctime;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private String text;

        public Note() {
        }

        public Note(String user, String text) {
            this(user, System.currentTimeMillis(), text);
        }

        public Note(String user, long ctime, String text) {
            this.user = user;
            this.ctime = ctime;
            this.text = text;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public long getCtime() {
            return this.ctime;
        }

        public void setCtime(long ctime) {
            this.ctime = ctime;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Note note = (Note)o;
            if (this.ctime != note.ctime) {
                return false;
            }
            if (this.user != null ? !this.user.equals(note.user) : note.user != null) {
                return false;
            }
            return !(this.text == null ? note.text != null : !this.text.equals(note.text));
        }

        public int hashCode() {
            int result = this.user != null ? this.user.hashCode() : 0;
            result = 31 * result + (int)(this.ctime ^ this.ctime >>> 32);
            result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Note{user='" + this.user + '\'' + ", ctime=" + this.ctime + ", text='" + this.text + '\'' + '}';
        }
    }

    public static enum Status {
        OPEN,
        ACKNOWLEDGED,
        RESOLVED;

    }
}

