/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.export;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import org.hawkular.alerts.api.model.action.ActionDefinition;
import org.hawkular.alerts.api.model.trigger.FullTrigger;

public class Definitions {
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<FullTrigger> triggers;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<ActionDefinition> actions;

    public Definitions() {
    }

    public Definitions(List<FullTrigger> triggers, List<ActionDefinition> actions) {
        this.triggers = triggers;
        this.actions = actions;
    }

    public List<FullTrigger> getTriggers() {
        return this.triggers;
    }

    public void setTriggers(List<FullTrigger> triggers) {
        this.triggers = triggers;
    }

    public List<ActionDefinition> getActions() {
        return this.actions;
    }

    public void setActions(List<ActionDefinition> actions) {
        this.actions = actions;
    }

    public void updateTenant(String tenantId) {
        if (this.triggers != null) {
            for (FullTrigger t : this.triggers) {
                if (t.getTrigger() == null) continue;
                t.getTrigger().setTenantId(tenantId);
                t.check();
            }
        }
        if (this.actions != null) {
            for (ActionDefinition a : this.actions) {
                if (a == null) continue;
                a.setTenantId(tenantId);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Definitions that = (Definitions)o;
        if (this.triggers != null ? !this.triggers.equals(that.triggers) : that.triggers != null) {
            return false;
        }
        return this.actions != null ? this.actions.equals(that.actions) : that.actions == null;
    }

    public int hashCode() {
        int result = this.triggers != null ? this.triggers.hashCode() : 0;
        result = 31 * result + (this.actions != null ? this.actions.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Definitions[triggers=" + this.triggers + ", actions=" + this.actions + ']';
    }
}

