/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.paging;

import java.util.ArrayList;
import java.util.List;
import org.hawkular.alerts.api.model.paging.Order;
import org.hawkular.alerts.api.model.paging.PageContext;

public final class Pager
extends PageContext {
    public static Builder builder() {
        return new Builder();
    }

    public static Pager unlimited(Order ... order) {
        return new Pager(0, -1, order);
    }

    public static Pager unlimited(Iterable<Order> order) {
        return new Pager(0, -1, order);
    }

    public Pager(int pageNumber, int pageSize, Order ... orders) {
        super(pageNumber, pageSize, orders);
    }

    public Pager(int pageNumber, int pageSize, Iterable<Order> orders) {
        super(pageNumber, pageSize, orders);
    }

    public Pager nextPage() {
        if (this.getPageSize() >= 0) {
            return new Pager(this.getPageNumber() + 1, this.getPageSize(), this.getOrder());
        }
        return this;
    }

    public Pager previousPage() {
        if (this.getPageNumber() > 0 && this.getPageSize() >= 0) {
            return new Pager(this.getPageNumber() - 1, this.getPageSize(), this.getOrder());
        }
        return this;
    }

    public static final class Builder {
        private int pageNumber;
        private int pageSize;
        private List<Order> order = new ArrayList<Order>();

        private Builder() {
        }

        public Builder withPageSize(int size) {
            this.pageSize = size;
            return this;
        }

        public Builder withStartPage(int pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder orderBy(String field, Order.Direction direction) {
            this.order.add(Order.by(field, direction));
            return this;
        }

        public Builder orderByAscending(String field) {
            return this.orderBy(field, Order.Direction.ASCENDING);
        }

        public Builder orderByDescending(String field) {
            return this.orderBy(field, Order.Direction.DESCENDING);
        }

        public Builder orderBy(Order order) {
            this.order.add(order);
            return this;
        }

        public Pager build() {
            return new Pager(this.pageNumber, this.pageSize, this.order);
        }
    }
}

