/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.action;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import org.hawkular.alerts.api.model.action.ActionDefinition;
import org.hawkular.alerts.api.model.event.Event;
import org.hawkular.alerts.api.model.event.Thin;

public class Action
extends ActionDefinition
implements Serializable {
    @JsonInclude
    private String eventId;
    @JsonInclude
    private long ctime;
    @Thin
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Event event;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String result;

    public Action() {
    }

    public Action(String tenantId, String actionPlugin, String actionId, Event event) {
        super(tenantId, actionPlugin, actionId);
        this.event = event;
        if (event != null) {
            this.eventId = event.getId();
        }
        this.ctime = System.currentTimeMillis();
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public long getCtime() {
        return this.ctime;
    }

    public void setCtime(long ctime) {
        this.ctime = ctime;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Action action = (Action)o;
        if (this.ctime != action.ctime) {
            return false;
        }
        if (this.eventId != null ? !this.eventId.equals(action.eventId) : action.eventId != null) {
            return false;
        }
        if (this.event != null ? !this.event.equals(action.event) : action.event != null) {
            return false;
        }
        return this.result != null ? this.result.equals(action.result) : action.result == null;
    }

    @Override
    public int hashCode() {
        int result1 = super.hashCode();
        result1 = 31 * result1 + (this.eventId != null ? this.eventId.hashCode() : 0);
        result1 = 31 * result1 + (int)(this.ctime ^ this.ctime >>> 32);
        result1 = 31 * result1 + (this.event != null ? this.event.hashCode() : 0);
        result1 = 31 * result1 + (this.result != null ? this.result.hashCode() : 0);
        return result1;
    }

    public String toString() {
        return "Action[eventId='" + this.eventId + '\'' + ", ctime=" + this.ctime + ", event=" + this.event + ", result='" + this.result + '\'' + ']';
    }
}

