/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.action;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hawkular.alerts.api.model.action.TimeConstraint;

public class ActionDefinition
implements Serializable {
    @JsonInclude
    private String tenantId;
    @JsonInclude
    private String actionPlugin;
    @JsonInclude
    private String actionId;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, String> properties;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Set<String> states;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private TimeConstraint calendar;

    public ActionDefinition() {
        this(null, null, null, new HashMap<String, String>(), null, null);
    }

    public ActionDefinition(String tenantId, String actionPlugin, String actionId) {
        this(tenantId, actionPlugin, actionId, new HashMap<String, String>(), null, null);
    }

    public ActionDefinition(String tenantId, String actionPlugin, String actionId, Map<String, String> properties) {
        this(tenantId, actionPlugin, actionId, properties, null, null);
    }

    public ActionDefinition(String tenantId, String actionPlugin, String actionId, Map<String, String> properties, Set<String> states, TimeConstraint calendar) {
        this.tenantId = tenantId;
        this.actionPlugin = actionPlugin;
        this.actionId = actionId;
        this.properties = properties != null ? new HashMap<String, String>(properties) : new HashMap();
        this.states = states != null ? new HashSet<String>(states) : new HashSet();
        this.calendar = calendar;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getActionPlugin() {
        return this.actionPlugin;
    }

    public void setActionPlugin(String actionPlugin) {
        this.actionPlugin = actionPlugin;
    }

    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Set<String> getStates() {
        if (this.states == null) {
            this.states = new HashSet<String>();
        }
        return this.states;
    }

    public void setStates(Set<String> states) {
        this.states = states;
    }

    public void addState(String state) {
        this.getStates().add(state);
    }

    public TimeConstraint getCalendar() {
        return this.calendar;
    }

    public void setCalendar(TimeConstraint calendar) {
        this.calendar = calendar;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionDefinition that = (ActionDefinition)o;
        if (this.tenantId != null ? !this.tenantId.equals(that.tenantId) : that.tenantId != null) {
            return false;
        }
        if (this.actionPlugin != null ? !this.actionPlugin.equals(that.actionPlugin) : that.actionPlugin != null) {
            return false;
        }
        if (this.actionId != null ? !this.actionId.equals(that.actionId) : that.actionId != null) {
            return false;
        }
        if (this.properties != null ? !this.properties.equals(that.properties) : that.properties != null) {
            return false;
        }
        if (this.states != null ? !this.states.equals(that.states) : that.states != null) {
            return false;
        }
        return this.calendar != null ? this.calendar.equals(that.calendar) : that.calendar == null;
    }

    public int hashCode() {
        int result = this.tenantId != null ? this.tenantId.hashCode() : 0;
        result = 31 * result + (this.actionPlugin != null ? this.actionPlugin.hashCode() : 0);
        result = 31 * result + (this.actionId != null ? this.actionId.hashCode() : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        result = 31 * result + (this.states != null ? this.states.hashCode() : 0);
        result = 31 * result + (this.calendar != null ? this.calendar.hashCode() : 0);
        return result;
    }
}

