/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.action;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class TimeConstraint
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final SimpleDateFormat dateParser = new SimpleDateFormat("yyyy.MM.dd");
    private static final SimpleDateFormat dateTimeParser = new SimpleDateFormat("yyyy.MM.dd,HH:mm");
    @JsonInclude
    private String startTime;
    @JsonInclude
    private String endTime;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private boolean relative;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private boolean inRange;
    @JsonIgnore
    private transient int startMonth = -1;
    @JsonIgnore
    private transient int startDay = -1;
    @JsonIgnore
    private transient int startMinute = -1;
    @JsonIgnore
    private transient int endMonth = -1;
    @JsonIgnore
    private transient int endDay = -1;
    @JsonIgnore
    private transient int endMinute = -1;
    @JsonIgnore
    private transient Date startDate = null;
    @JsonIgnore
    private transient Date endDate = null;

    public TimeConstraint() {
        this("Jan", "Dec", true, true);
    }

    public TimeConstraint(String startTime, String endTime) {
        this(startTime, endTime, true, true);
    }

    public TimeConstraint(String startTime, String endTime, boolean relative) {
        this(startTime, endTime, relative, true);
    }

    public TimeConstraint(String startTime, String endTime, boolean relative, boolean inRange) {
        if (this.isEmpty(startTime)) {
            throw new IllegalArgumentException("startTime must be not null");
        }
        if (this.isEmpty(endTime)) {
            throw new IllegalArgumentException("endTime must be not null");
        }
        this.startTime = startTime;
        this.endTime = endTime;
        this.relative = relative;
        this.inRange = inRange;
        if (relative) {
            this.updateRelative();
        } else {
            this.updateAbsolute();
        }
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        if (this.isEmpty(startTime)) {
            throw new IllegalArgumentException("startTime must be not null");
        }
        this.startTime = startTime;
        if (this.relative) {
            this.updateRelative();
        } else {
            this.updateAbsolute();
        }
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        if (this.isEmpty(endTime)) {
            throw new IllegalArgumentException("endTime must be not null");
        }
        this.endTime = endTime;
        if (this.relative) {
            this.updateRelative();
        } else {
            this.updateAbsolute();
        }
    }

    public boolean isRelative() {
        return this.relative;
    }

    public void setRelative(boolean relative) {
        this.relative = relative;
        if (relative) {
            this.updateRelative();
        } else {
            this.updateAbsolute();
        }
    }

    public boolean isInRange() {
        return this.inRange;
    }

    public void setInRange(boolean inRange) {
        this.inRange = inRange;
        if (this.relative) {
            this.updateRelative();
        } else {
            this.updateAbsolute();
        }
    }

    @JsonIgnore
    public boolean isSatisfiedBy(long timestamp) throws IllegalArgumentException {
        if (this.relative) {
            return this.checkRelative(timestamp);
        }
        return this.checkAbsolute(timestamp);
    }

    private void updateRelative() {
        this.startMonth = -1;
        this.endMonth = -1;
        this.startDay = -1;
        this.endDay = -1;
        this.startMinute = -1;
        this.endMinute = -1;
        String[] start = this.startTime.split(",");
        String[] end = this.endTime.split(",");
        int startFields = start.length;
        if (startFields > 3) {
            throw new IllegalArgumentException("startTime has more than 3 fields");
        }
        int endFields = end.length;
        if (endFields > 3) {
            throw new IllegalArgumentException("endTime has more than 3 fields");
        }
        switch (startFields) {
            case 3: {
                this.startMonth = this.month(start[0]);
                this.startDay = this.day(start[1]);
                this.startMinute = this.minute(start[2]);
                break;
            }
            case 2: {
                this.startMonth = this.month(start[0]);
                this.startDay = this.day(start[0]);
                this.startMinute = this.minute(start[1]);
                break;
            }
            case 1: {
                this.startMonth = this.month(start[0]);
                this.startDay = this.day(start[0]);
                this.startMinute = this.minute(start[0]);
                break;
            }
        }
        switch (endFields) {
            case 3: {
                this.endMonth = this.month(end[0]);
                this.endDay = this.day(end[1]);
                this.endMinute = this.minute(end[2]);
                break;
            }
            case 2: {
                this.endMonth = this.month(end[0]);
                this.endDay = this.day(end[0]);
                this.endMinute = this.minute(end[1]);
                break;
            }
            case 1: {
                this.endMonth = this.month(end[0]);
                this.endDay = this.day(end[0]);
                this.endMinute = this.minute(end[0]);
                break;
            }
        }
        if (this.startMonth == -1 && this.startDay == -1 && this.startMinute == -1) {
            throw new IllegalArgumentException("Bad format on startTime: " + this.startTime);
        }
        if (this.endMonth == -1 && this.endDay == -1 && this.endMinute == -1) {
            throw new IllegalArgumentException("Bad format on endTime: " + this.endTime);
        }
    }

    private boolean isInInterval(int start, int end, int value) {
        if (start <= end) {
            return start <= value && value <= end;
        }
        return start <= value || value <= end;
    }

    private boolean checkRelative(long timestamp) throws IllegalArgumentException {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timestamp);
        if (this.inRange) {
            int month = cal.get(2);
            if (this.startMonth != -1 && this.endMonth != -1 && !this.isInInterval(this.startMonth, this.endMonth, month)) {
                return false;
            }
            int day = cal.get(7);
            if (this.startDay != -1 && this.endDay != -1 && !this.isInInterval(this.startDay, this.endDay, day)) {
                return false;
            }
            int minute = cal.get(11) * 60 + cal.get(12);
            return this.startMinute == -1 || this.endMinute == -1 || this.isInInterval(this.startMinute, this.endMinute, minute);
        }
        int month = cal.get(2);
        if (this.startMonth != -1 && this.endMonth != -1 && !this.isInInterval(this.startMonth, this.endMonth, month)) {
            return true;
        }
        int day = cal.get(7);
        if (this.startDay != -1 && this.endDay != -1 && !this.isInInterval(this.startDay, this.endDay, day)) {
            return true;
        }
        int minute = cal.get(11) * 60 + cal.get(12);
        return this.startMinute != -1 && this.endMinute != -1 && !this.isInInterval(this.startMinute, this.endMinute, minute);
    }

    private int month(String sMonth) {
        if (this.isEmpty(sMonth)) {
            return -1;
        }
        if (sMonth.length() < 3) {
            return -1;
        }
        String prefix = sMonth.substring(0, 3).toLowerCase();
        MONTH m = MONTH.fromString(prefix);
        if (m == null) {
            return -1;
        }
        switch (m) {
            case JANUARY: {
                return 0;
            }
            case FEBRUARY: {
                return 1;
            }
            case MARCH: {
                return 2;
            }
            case APRIL: {
                return 3;
            }
            case MAY: {
                return 4;
            }
            case JUNE: {
                return 5;
            }
            case JULY: {
                return 6;
            }
            case AUGUST: {
                return 7;
            }
            case SEPTEMBER: {
                return 8;
            }
            case OCTOBER: {
                return 9;
            }
            case NOVEMBER: {
                return 10;
            }
            case DECEMBER: {
                return 11;
            }
        }
        return -1;
    }

    private int day(String sDay) {
        if (this.isEmpty(sDay)) {
            return -1;
        }
        if (sDay.length() < 3) {
            return -1;
        }
        String prefix = sDay.substring(0, 3).toLowerCase();
        DAY d = DAY.fromString(prefix);
        if (d == null) {
            return -1;
        }
        switch (d) {
            case SUNDAY: {
                return 1;
            }
            case MONDAY: {
                return 2;
            }
            case TUESDAY: {
                return 3;
            }
            case WEDNESDAY: {
                return 4;
            }
            case THURSDAY: {
                return 5;
            }
            case FRIDAY: {
                return 6;
            }
            case SATURDAY: {
                return 7;
            }
        }
        return -1;
    }

    private int minute(String sTime) {
        if (this.isEmpty(sTime)) {
            return -1;
        }
        int separator = sTime.indexOf(":");
        if (separator < 0) {
            return -1;
        }
        try {
            return Integer.valueOf(sTime.substring(0, separator)) * 60 + Integer.valueOf(sTime.substring(separator + 1));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private boolean checkAbsolute(long timestamp) throws IllegalArgumentException {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timestamp);
        Date timeDate = cal.getTime();
        if (this.inRange) {
            return this.startDate.compareTo(timeDate) <= 0 && this.endDate.compareTo(timeDate) >= 0;
        }
        return this.startDate.compareTo(timeDate) > 0 || this.endDate.compareTo(timeDate) < 0;
    }

    private void updateAbsolute() {
        this.startDate = null;
        this.endDate = null;
        try {
            this.startDate = this.startTime.indexOf(",") == -1 ? dateParser.parse(this.startTime) : dateTimeParser.parse(this.startTime);
            this.endDate = this.endTime.indexOf(",") == -1 ? dateParser.parse(this.endTime) : dateTimeParser.parse(this.endTime);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Bad format on startTime and/or endTime: " + e.getMessage());
        }
    }

    private boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public String toString() {
        return "TimeConstraint[startTime='" + this.startTime + '\'' + ", endTime='" + this.endTime + '\'' + ", relative=" + this.relative + ", inRange=" + this.inRange + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeConstraint that = (TimeConstraint)o;
        if (this.relative != that.relative) {
            return false;
        }
        if (this.inRange != that.inRange) {
            return false;
        }
        if (this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null) {
            return false;
        }
        return this.endTime != null ? this.endTime.equals(that.endTime) : that.endTime == null;
    }

    public int hashCode() {
        int result = this.startTime != null ? this.startTime.hashCode() : 0;
        result = 31 * result + (this.endTime != null ? this.endTime.hashCode() : 0);
        result = 31 * result + (this.relative ? 1 : 0);
        result = 31 * result + (this.inRange ? 1 : 0);
        return result;
    }

    public static enum DAY {
        SUNDAY("sun"),
        MONDAY("mon"),
        TUESDAY("tue"),
        WEDNESDAY("wed"),
        THURSDAY("thu"),
        FRIDAY("fri"),
        SATURDAY("sat");

        private String day;

        private DAY(String day) {
            this.day = day;
        }

        public String getDay() {
            return this.day;
        }

        public static DAY fromString(String s) {
            if (s == null || s.isEmpty()) {
                return null;
            }
            for (DAY d : DAY.values()) {
                if (!d.getDay().equalsIgnoreCase(s)) continue;
                return d;
            }
            return null;
        }
    }

    public static enum MONTH {
        JANUARY("jan"),
        FEBRUARY("feb"),
        MARCH("mar"),
        APRIL("apr"),
        MAY("may"),
        JUNE("jun"),
        JULY("jul"),
        AUGUST("aug"),
        SEPTEMBER("sep"),
        OCTOBER("oct"),
        NOVEMBER("nov"),
        DECEMBER("dec");

        private String month;

        private MONTH(String month) {
            this.month = month;
        }

        public String getMonth() {
            return this.month;
        }

        public static MONTH fromString(String s) {
            if (s == null || s.isEmpty()) {
                return null;
            }
            for (MONTH m : MONTH.values()) {
                if (!m.getMonth().equalsIgnoreCase(s)) continue;
                return m;
            }
            return null;
        }
    }
}

