/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.condition;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.trigger.Mode;

public class CompareCondition
extends Condition {
    private static final long serialVersionUID = 1L;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String dataId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Operator operator;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String data2Id;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Double data2Multiplier;

    public CompareCondition() {
        this("", "", 1, 1, null, null, null, null);
    }

    public CompareCondition(String tenantId, String triggerId, String dataId, Operator operator, Double data2Multiplier, String data2Id) {
        this(tenantId, triggerId, Mode.FIRING, 1, 1, dataId, operator, data2Multiplier, data2Id);
    }

    public CompareCondition(String triggerId, Mode triggerMode, String dataId, Operator operator, Double data2Multiplier, String data2Id) {
        this("", triggerId, triggerMode, 1, 1, dataId, operator, data2Multiplier, data2Id);
    }

    public CompareCondition(String tenantId, String triggerId, Mode triggerMode, String dataId, Operator operator, Double data2Multiplier, String data2Id) {
        this(tenantId, triggerId, triggerMode, 1, 1, dataId, operator, data2Multiplier, data2Id);
    }

    public CompareCondition(String tenantId, String triggerId, int conditionSetSize, int conditionSetIndex, String dataId, Operator operator, Double data2Multiplier, String data2Id) {
        this(tenantId, triggerId, Mode.FIRING, conditionSetSize, conditionSetIndex, dataId, operator, data2Multiplier, data2Id);
    }

    public CompareCondition(String triggerId, Mode triggerMode, int conditionSetSize, int conditionSetIndex, String dataId, Operator operator, Double data2Multiplier, String data2Id) {
        this("", triggerId, triggerMode, conditionSetSize, conditionSetIndex, dataId, operator, data2Multiplier, data2Id);
    }

    public CompareCondition(String tenantId, String triggerId, Mode triggerMode, int conditionSetSize, int conditionSetIndex, String dataId, Operator operator, Double data2Multiplier, String data2Id) {
        super(tenantId, triggerId, triggerMode, conditionSetSize, conditionSetIndex, Condition.Type.COMPARE);
        this.dataId = dataId;
        this.operator = operator;
        this.data2Id = data2Id;
        this.data2Multiplier = data2Multiplier;
    }

    @Override
    public String getDataId() {
        return this.dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public String getData2Id() {
        return this.data2Id;
    }

    public void setData2Id(String data2Id) {
        this.data2Id = data2Id;
    }

    public Double getData2Multiplier() {
        return this.data2Multiplier;
    }

    public void setData2Multiplier(Double data2Multiplier) {
        this.data2Multiplier = data2Multiplier;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public String getLog(double dataValue, double data2Value) {
        Double val = this.data2Multiplier * data2Value;
        return this.triggerId + " : " + dataValue + " " + this.operator.name() + " " + val + " (" + this.data2Multiplier + "*" + data2Value + ")";
    }

    public boolean match(double dataValue, double data2Value) {
        double threshold = this.data2Multiplier * data2Value;
        switch (this.operator) {
            case LT: {
                return dataValue < threshold;
            }
            case GT: {
                return dataValue > threshold;
            }
            case LTE: {
                return dataValue <= threshold;
            }
            case GTE: {
                return dataValue >= threshold;
            }
        }
        throw new IllegalStateException("Unknown operator: " + this.operator.name());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CompareCondition that = (CompareCondition)o;
        if (this.dataId != null ? !this.dataId.equals(that.dataId) : that.dataId != null) {
            return false;
        }
        if (this.data2Id != null ? !this.data2Id.equals(that.data2Id) : that.data2Id != null) {
            return false;
        }
        if (this.data2Multiplier != null ? !this.data2Multiplier.equals(that.data2Multiplier) : that.data2Multiplier != null) {
            return false;
        }
        return this.operator == that.operator;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.dataId != null ? this.dataId.hashCode() : 0);
        result = 31 * result + (this.operator != null ? this.operator.hashCode() : 0);
        result = 31 * result + (this.data2Id != null ? this.data2Id.hashCode() : 0);
        result = 31 * result + (this.data2Multiplier != null ? this.data2Multiplier.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "CompareCondition [triggerId='" + this.triggerId + "', " + "triggerMode=" + (Object)((Object)this.triggerMode) + ", " + "dataId=" + (this.dataId == null ? null : '\'' + this.dataId + '\'') + ", " + "operator=" + (this.operator == null ? null : '\'' + this.operator.toString() + '\'') + ", " + "data2Id=" + (this.data2Id == null ? null : '\'' + this.data2Id + '\'') + ", " + "data2Multiplier=" + this.data2Multiplier + "]";
    }

    public static enum Operator {
        LT,
        GT,
        LTE,
        GTE;

    }
}

