/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.condition;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.ConditionEval;
import org.hawkular.alerts.api.model.condition.ExternalCondition;
import org.hawkular.alerts.api.model.data.Data;

public class ExternalConditionEval
extends ConditionEval {
    private static final long serialVersionUID = 1L;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private ExternalCondition condition;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String value;

    public ExternalConditionEval() {
        super(Condition.Type.EXTERNAL, false, 0L, null);
        this.condition = null;
        this.value = null;
    }

    public ExternalConditionEval(ExternalCondition condition, Data data) {
        super(Condition.Type.EXTERNAL, condition.match(data.getValue()), data.getTimestamp(), data.getContext());
        this.condition = condition;
        this.value = data.getValue();
    }

    public ExternalCondition getCondition() {
        return this.condition;
    }

    public void setCondition(ExternalCondition condition) {
        this.condition = condition;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String getTenantId() {
        return this.condition.getTenantId();
    }

    @Override
    public String getTriggerId() {
        return this.condition.getTriggerId();
    }

    @Override
    public int getConditionSetSize() {
        return this.condition.getConditionSetSize();
    }

    @Override
    public int getConditionSetIndex() {
        return this.condition.getConditionSetIndex();
    }

    @Override
    public String getLog() {
        return this.condition.getLog(this.value) + ", evalTimestamp=" + this.evalTimestamp + ", dataTimestamp=" + this.dataTimestamp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExternalConditionEval that = (ExternalConditionEval)o;
        if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "StringConditionEval [evalTimestamp=" + this.evalTimestamp + ", " + "dataTimestamp=" + this.dataTimestamp + ", " + "condition=" + this.condition + ", " + "value=" + this.value + "]";
    }
}

