/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.trigger;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hawkular.alerts.api.model.action.TimeConstraint;

public class TriggerAction
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String tenantId;
    @JsonInclude
    private String actionPlugin;
    @JsonInclude
    private String actionId;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Set<String> states;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private TimeConstraint calendar;

    public TriggerAction() {
        this(null, null, null);
    }

    public TriggerAction(String actionPlugin, String actionId) {
        this(null, actionPlugin, actionId);
    }

    public TriggerAction(String tenantId, String actionPlugin, String actionId) {
        this(tenantId, actionPlugin, actionId, new HashSet<String>(), null);
    }

    public TriggerAction(String tenantId, String actionPlugin, String actionId, Set<String> states) {
        this(tenantId, actionPlugin, actionId, new HashSet<String>(states), null);
    }

    public TriggerAction(String tenantId, String actionPlugin, String actionId, TimeConstraint calendar) {
        this(tenantId, actionPlugin, actionId, new HashSet<String>(), calendar);
    }

    public TriggerAction(String tenantId, String actionPlugin, String actionId, Set<String> states, TimeConstraint calendar) {
        this.tenantId = tenantId;
        this.actionPlugin = actionPlugin;
        this.actionId = actionId;
        this.states = states;
        this.calendar = calendar;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getActionPlugin() {
        return this.actionPlugin;
    }

    public void setActionPlugin(String actionPlugin) {
        this.actionPlugin = actionPlugin;
    }

    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public Set<String> getStates() {
        if (this.states == null) {
            this.states = new HashSet<String>();
        }
        return this.states;
    }

    public void setStates(Set<String> states) {
        this.states = states;
    }

    public void addState(String state) {
        this.getStates().add(state);
    }

    public TimeConstraint getCalendar() {
        return this.calendar;
    }

    public void setCalendar(TimeConstraint calendar) {
        this.calendar = calendar;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TriggerAction that = (TriggerAction)o;
        if (this.tenantId != null ? !this.tenantId.equals(that.tenantId) : that.tenantId != null) {
            return false;
        }
        if (this.actionPlugin != null ? !this.actionPlugin.equals(that.actionPlugin) : that.actionPlugin != null) {
            return false;
        }
        if (this.actionId != null ? !this.actionId.equals(that.actionId) : that.actionId != null) {
            return false;
        }
        if (this.states != null ? !this.states.equals(that.states) : that.states != null) {
            return false;
        }
        return this.calendar != null ? this.calendar.equals(that.calendar) : that.calendar == null;
    }

    public int hashCode() {
        int result = this.tenantId != null ? this.tenantId.hashCode() : 0;
        result = 31 * result + (this.actionPlugin != null ? this.actionPlugin.hashCode() : 0);
        result = 31 * result + (this.actionId != null ? this.actionId.hashCode() : 0);
        result = 31 * result + (this.states != null ? this.states.hashCode() : 0);
        result = 31 * result + (this.calendar != null ? this.calendar.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TriggerAction[tenantId='" + this.tenantId + '\'' + ", actionPlugin='" + this.actionPlugin + '\'' + ", actionId='" + this.actionId + '\'' + ", states=" + this.states + ", calendar='" + this.calendar + '\'' + ']';
    }
}

