/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.hawkular.alerts.api.json.JacksonDeserializer;

public class JsonUtil {
    private static JsonUtil instance = new JsonUtil();
    private ObjectMapper mapper = new ObjectMapper();
    private ObjectMapper mapperThin;

    private JsonUtil() {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.setDeserializerModifier((BeanDeserializerModifier)new JacksonDeserializer.AlertThinDeserializer());
        this.mapperThin = new ObjectMapper();
        this.mapperThin.registerModule((Module)simpleModule);
    }

    public static String toJson(Object resource) {
        try {
            return JsonUtil.instance.mapper.writeValueAsString(resource);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        return JsonUtil.fromJson(json, clazz, false);
    }

    public static <T> T fromJson(String json, Class<T> clazz, boolean thin) {
        try {
            return (T)(thin ? JsonUtil.instance.mapperThin.readValue(json, clazz) : JsonUtil.instance.mapper.readValue(json, clazz));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

