/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.condition;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.trigger.Mode;

public class ThresholdCondition
extends Condition {
    private static final long serialVersionUID = 1L;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String dataId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Operator operator;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Double threshold;

    public ThresholdCondition() {
        this("", "", 1, 1, null, null, null);
    }

    public ThresholdCondition(String tenantId, String triggerId, String dataId, Operator operator, Double threshold) {
        this(tenantId, triggerId, Mode.FIRING, 1, 1, dataId, operator, threshold);
    }

    public ThresholdCondition(String triggerId, Mode triggerMode, String dataId, Operator operator, Double threshold) {
        this("", triggerId, triggerMode, 1, 1, dataId, operator, threshold);
    }

    public ThresholdCondition(String tenantId, String triggerId, Mode triggerMode, String dataId, Operator operator, Double threshold) {
        this(tenantId, triggerId, triggerMode, 1, 1, dataId, operator, threshold);
    }

    public ThresholdCondition(String tenantId, String triggerId, int conditionSetSize, int conditionSetIndex, String dataId, Operator operator, Double threshold) {
        this(tenantId, triggerId, Mode.FIRING, conditionSetSize, conditionSetIndex, dataId, operator, threshold);
    }

    public ThresholdCondition(String triggerId, Mode triggerMode, int conditionSetSize, int conditionSetIndex, String dataId, Operator operator, Double threshold) {
        this("", triggerId, triggerMode, conditionSetSize, conditionSetIndex, dataId, operator, threshold);
    }

    public ThresholdCondition(String tenantId, String triggerId, Mode triggerMode, int conditionSetSize, int conditionSetIndex, String dataId, Operator operator, Double threshold) {
        super(tenantId, triggerId, triggerMode, conditionSetSize, conditionSetIndex, Condition.Type.THRESHOLD);
        this.dataId = dataId;
        this.operator = operator;
        this.threshold = threshold;
    }

    @Override
    public String getDataId() {
        return this.dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public Double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Double threshold) {
        this.threshold = threshold;
    }

    public String getLog(double value) {
        return this.triggerId + " : " + value + " " + this.operator.name() + " " + this.threshold;
    }

    public boolean match(double value) {
        switch (this.operator) {
            case LT: {
                return value < this.threshold;
            }
            case GT: {
                return value > this.threshold;
            }
            case LTE: {
                return value <= this.threshold;
            }
            case GTE: {
                return value >= this.threshold;
            }
        }
        throw new IllegalStateException("Unknown operator: " + this.operator.name());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ThresholdCondition that = (ThresholdCondition)o;
        if (this.dataId != null ? !this.dataId.equals(that.dataId) : that.dataId != null) {
            return false;
        }
        if (this.operator != that.operator) {
            return false;
        }
        return !(this.threshold != null ? !this.threshold.equals(that.threshold) : that.threshold != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.dataId != null ? this.dataId.hashCode() : 0);
        result = 31 * result + (this.operator != null ? this.operator.hashCode() : 0);
        result = 31 * result + (this.threshold != null ? this.threshold.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ThresholdCondition [triggerId='" + this.triggerId + "', triggerMode=" + (Object)((Object)this.triggerMode) + ", dataId=" + (this.dataId == null ? null : '\'' + this.dataId + '\'') + ", operator=" + (this.operator == null ? null : '\'' + this.operator.toString() + '\'') + ", threshold=" + this.threshold + "]";
    }

    public static enum Operator {
        LT,
        GT,
        LTE,
        GTE;

    }
}

