/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.condition;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.data.AvailabilityType;
import org.hawkular.alerts.api.model.trigger.Mode;

public class AvailabilityCondition
extends Condition {
    private static final long serialVersionUID = 1L;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String dataId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Operator operator;

    public AvailabilityCondition() {
        this("", "", 1, 1, null, null);
    }

    public AvailabilityCondition(String tenantId, String triggerId, String dataId, Operator operator) {
        this(tenantId, triggerId, Mode.FIRING, 1, 1, dataId, operator);
    }

    public AvailabilityCondition(String triggerId, Mode triggerMode, String dataId, Operator operator) {
        this("", triggerId, triggerMode, 1, 1, dataId, operator);
    }

    public AvailabilityCondition(String tenantId, String triggerId, Mode triggerMode, String dataId, Operator operator) {
        this(tenantId, triggerId, triggerMode, 1, 1, dataId, operator);
    }

    public AvailabilityCondition(String tenantId, String triggerId, int conditionSetSize, int conditionSetIndex, String dataId, Operator operator) {
        this(tenantId, triggerId, Mode.FIRING, conditionSetSize, conditionSetIndex, dataId, operator);
    }

    public AvailabilityCondition(String triggerId, Mode triggerMode, int conditionSetSize, int conditionSetIndex, String dataId, Operator operator) {
        this("", triggerId, triggerMode, conditionSetSize, conditionSetIndex, dataId, operator);
    }

    public AvailabilityCondition(String tenantId, String triggerId, Mode triggerMode, int conditionSetSize, int conditionSetIndex, String dataId, Operator operator) {
        super(tenantId, triggerId, triggerMode, conditionSetSize, conditionSetIndex, Condition.Type.AVAILABILITY);
        this.dataId = dataId;
        this.operator = operator;
    }

    @Override
    public String getDataId() {
        return this.dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public String getLog(AvailabilityType value) {
        return this.triggerId + " : " + (Object)((Object)value) + " " + this.operator.name();
    }

    public boolean match(AvailabilityType value) {
        switch (this.operator) {
            case DOWN: {
                return value == AvailabilityType.DOWN;
            }
            case UP: {
                return value == AvailabilityType.UP;
            }
            case NOT_UP: {
                return value != AvailabilityType.UP;
            }
        }
        throw new IllegalStateException("Unknown operator: " + this.operator.name());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AvailabilityCondition that = (AvailabilityCondition)o;
        if (this.dataId != null ? !this.dataId.equals(that.dataId) : that.dataId != null) {
            return false;
        }
        return this.operator == that.operator;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.dataId != null ? this.dataId.hashCode() : 0);
        result = 31 * result + (this.operator != null ? this.operator.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "AvailabilityCondition [triggerId='" + this.triggerId + "', triggerMode=" + (Object)((Object)this.triggerMode) + ", dataId=" + (this.dataId == null ? null : '\'' + this.dataId + '\'') + ", operator=" + (this.operator == null ? null : '\'' + this.operator.toString() + '\'') + "]";
    }

    public static enum Operator {
        DOWN,
        NOT_UP,
        UP;

    }
}

