/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.condition;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Map;
import org.hawkular.alerts.api.model.condition.CompareCondition;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.ConditionEval;
import org.hawkular.alerts.api.model.data.Data;

public class CompareConditionEval
extends ConditionEval {
    private static final long serialVersionUID = 1L;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private CompareCondition condition;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Double value1;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Double value2;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected Map<String, String> context2;

    public CompareConditionEval() {
        super(Condition.Type.COMPARE, false, 0L, null);
        this.condition = null;
        this.value1 = null;
        this.value2 = null;
        this.context2 = null;
    }

    public CompareConditionEval(CompareCondition condition, Data data1, Data data2) {
        super(Condition.Type.COMPARE, condition.match(Double.valueOf(data1.getValue()), Double.valueOf(data2.getValue())), data1.getTimestamp() > data1.getTimestamp() ? data1.getTimestamp() : data2.getTimestamp(), data1.getContext());
        this.condition = condition;
        this.value1 = Double.valueOf(data1.getValue());
        this.value2 = Double.valueOf(data2.getValue());
        this.context2 = data2.getContext();
    }

    public CompareCondition getCondition() {
        return this.condition;
    }

    public void setCondition(CompareCondition condition) {
        this.condition = condition;
    }

    public Double getValue1() {
        return this.value1;
    }

    public void setValue1(Double value1) {
        this.value1 = value1;
    }

    public Double getValue2() {
        return this.value2;
    }

    public void setValue2(Double value2) {
        this.value2 = value2;
    }

    @Override
    public String getTenantId() {
        return this.condition.getTenantId();
    }

    @Override
    public String getTriggerId() {
        return this.condition.getTriggerId();
    }

    @Override
    public int getConditionSetSize() {
        return this.condition.getConditionSetSize();
    }

    @Override
    public int getConditionSetIndex() {
        return this.condition.getConditionSetIndex();
    }

    public Map<String, String> getContext2() {
        return this.context2;
    }

    public void setContext2(Map<String, String> context2) {
        this.context2 = context2;
    }

    @Override
    public String getLog() {
        return this.condition.getLog(this.value1, this.value2) + ", evalTimestamp=" + this.evalTimestamp + ", dataTimestamp=" + this.dataTimestamp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CompareConditionEval that = (CompareConditionEval)o;
        if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) {
            return false;
        }
        if (this.value1 != null ? !this.value1.equals(that.value1) : that.value1 != null) {
            return false;
        }
        if (this.value2 != null ? !this.value2.equals(that.value2) : that.value2 != null) {
            return false;
        }
        return !(this.context2 == null ? that.context2 != null : !this.context2.equals(that.context2));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
        result = 31 * result + (this.value1 != null ? this.value1.hashCode() : 0);
        result = 31 * result + (this.value2 != null ? this.value2.hashCode() : 0);
        result = 31 * result + (this.context2 != null ? this.context2.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "CompareConditionEval [condition=" + this.condition + ", value1=" + this.value1 + ", value2=" + this.value2 + ", match=" + this.match + ", evalTimestamp=" + this.evalTimestamp + ", dataTimestamp=" + this.dataTimestamp + "]";
    }
}

