/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.json;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hawkular.alerts.api.model.action.Action;
import org.hawkular.alerts.api.model.condition.AvailabilityCondition;
import org.hawkular.alerts.api.model.condition.AvailabilityConditionEval;
import org.hawkular.alerts.api.model.condition.CompareCondition;
import org.hawkular.alerts.api.model.condition.CompareConditionEval;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.ConditionEval;
import org.hawkular.alerts.api.model.condition.EventCondition;
import org.hawkular.alerts.api.model.condition.EventConditionEval;
import org.hawkular.alerts.api.model.condition.ExternalCondition;
import org.hawkular.alerts.api.model.condition.ExternalConditionEval;
import org.hawkular.alerts.api.model.condition.MissingCondition;
import org.hawkular.alerts.api.model.condition.MissingConditionEval;
import org.hawkular.alerts.api.model.condition.RateCondition;
import org.hawkular.alerts.api.model.condition.RateConditionEval;
import org.hawkular.alerts.api.model.condition.StringCondition;
import org.hawkular.alerts.api.model.condition.StringConditionEval;
import org.hawkular.alerts.api.model.condition.ThresholdCondition;
import org.hawkular.alerts.api.model.condition.ThresholdConditionEval;
import org.hawkular.alerts.api.model.condition.ThresholdRangeCondition;
import org.hawkular.alerts.api.model.condition.ThresholdRangeConditionEval;
import org.hawkular.alerts.api.model.data.AvailabilityType;
import org.hawkular.alerts.api.model.event.Alert;
import org.hawkular.alerts.api.model.event.Event;
import org.hawkular.alerts.api.model.event.Thin;
import org.hawkular.alerts.api.model.trigger.Mode;

public class JacksonDeserializer {
    public static Condition deserializeCondition(JsonNode node) throws JsonProcessingException {
        if (node == null) {
            return null;
        }
        Condition condition = null;
        Condition.Type conditionType = null;
        if (node.get("type") == null) {
            throw new ConditionException("Condition must have a type");
        }
        try {
            conditionType = Condition.Type.valueOf(node.get("type").asText().toUpperCase());
        }
        catch (Exception e) {
            throw new ConditionException(e);
        }
        switch (conditionType) {
            case THRESHOLD: {
                try {
                    Condition tCondition = condition = new ThresholdCondition();
                    if (node.get("dataId") != null) {
                        ((ThresholdCondition)tCondition).setDataId(node.get("dataId").textValue());
                    }
                    if (node.get("operator") != null) {
                        ((ThresholdCondition)tCondition).setOperator(ThresholdCondition.Operator.valueOf(node.get("operator").textValue()));
                    }
                    if (node.get("threshold") == null) break;
                    ((ThresholdCondition)tCondition).setThreshold(node.get("threshold").doubleValue());
                    break;
                }
                catch (Exception e) {
                    throw new ConditionException(e);
                }
            }
            case AVAILABILITY: {
                try {
                    condition = new AvailabilityCondition();
                    AvailabilityCondition aCondition = (AvailabilityCondition)condition;
                    if (node.get("dataId") != null) {
                        aCondition.setDataId(node.get("dataId").textValue());
                    }
                    if (node.get("operator") == null) break;
                    aCondition.setOperator(AvailabilityCondition.Operator.valueOf(node.get("operator").textValue()));
                    break;
                }
                catch (Exception e) {
                    throw new ConditionException(e);
                }
            }
            case COMPARE: {
                try {
                    condition = new CompareCondition();
                    CompareCondition cCondition = (CompareCondition)condition;
                    if (node.get("dataId") != null) {
                        cCondition.setDataId(node.get("dataId").textValue());
                    }
                    if (node.get("operator") != null) {
                        cCondition.setOperator(CompareCondition.Operator.valueOf(node.get("operator").textValue()));
                    }
                    if (node.get("data2Id") != null) {
                        cCondition.setData2Id(node.get("data2Id").textValue());
                    }
                    if (node.get("data2Multiplier") == null) break;
                    cCondition.setData2Multiplier(node.get("data2Multiplier").doubleValue());
                    break;
                }
                catch (Exception e) {
                    throw new ConditionException(e);
                }
            }
            case RANGE: {
                Condition rCondition;
                try {
                    condition = new ThresholdRangeCondition();
                    rCondition = (ThresholdRangeCondition)condition;
                    if (node.get("dataId") != null) {
                        ((ThresholdRangeCondition)rCondition).setDataId(node.get("dataId").textValue());
                    }
                    if (node.get("operatorLow") != null) {
                        ((ThresholdRangeCondition)rCondition).setOperatorLow(ThresholdRangeCondition.Operator.valueOf(node.get("operatorLow").textValue()));
                    }
                    if (node.get("operatorHigh") != null) {
                        ((ThresholdRangeCondition)rCondition).setOperatorHigh(ThresholdRangeCondition.Operator.valueOf(node.get("operatorHigh").textValue()));
                    }
                    if (node.get("thresholdLow") != null) {
                        ((ThresholdRangeCondition)rCondition).setThresholdLow(node.get("thresholdLow").doubleValue());
                    }
                    if (node.get("thresholdHigh") != null) {
                        ((ThresholdRangeCondition)rCondition).setThresholdHigh(node.get("thresholdHigh").doubleValue());
                    }
                    if (node.get("inRange") == null) break;
                    ((ThresholdRangeCondition)rCondition).setInRange(node.get("inRange").booleanValue());
                    break;
                }
                catch (Exception e) {
                    throw new ConditionException(e);
                }
            }
            case STRING: {
                try {
                    condition = new StringCondition();
                    StringCondition sCondition = (StringCondition)condition;
                    if (node.get("dataId") != null) {
                        sCondition.setDataId(node.get("dataId").textValue());
                    }
                    if (node.get("operator") != null) {
                        sCondition.setOperator(StringCondition.Operator.valueOf(node.get("operator").textValue()));
                    }
                    if (node.get("pattern") != null) {
                        sCondition.setPattern(node.get("pattern").textValue());
                    }
                    if (node.get("ignoreCase") == null) break;
                    sCondition.setIgnoreCase(node.get("ignoreCase").booleanValue());
                    break;
                }
                catch (Exception e) {
                    throw new ConditionException(e);
                }
            }
            case EXTERNAL: {
                try {
                    condition = new ExternalCondition();
                    ExternalCondition eCondition = (ExternalCondition)condition;
                    if (node.get("alerterId") != null) {
                        eCondition.setAlerterId(node.get("alerterId").textValue());
                    }
                    if (node.get("dataId") != null) {
                        eCondition.setDataId(node.get("dataId").textValue());
                    }
                    if (node.get("expression") == null) break;
                    eCondition.setExpression(node.get("expression").textValue());
                    break;
                }
                catch (Exception e) {
                    throw new ConditionException(e);
                }
            }
            case EVENT: {
                try {
                    condition = new EventCondition();
                    EventCondition evCondition = (EventCondition)condition;
                    if (node.get("dataId") != null) {
                        evCondition.setDataId(node.get("dataId").textValue());
                    }
                    if (node.get("expression") == null) break;
                    evCondition.setExpression(node.get("expression").textValue());
                    break;
                }
                catch (Exception e) {
                    throw new ConditionException(e);
                }
            }
            case MISSING: {
                try {
                    condition = new MissingCondition();
                    MissingCondition mCondition = (MissingCondition)condition;
                    if (node.get("dataId") != null) {
                        mCondition.setDataId(node.get("dataId").textValue());
                    }
                    if (node.get("interval") == null) break;
                    mCondition.setInterval(node.get("interval").longValue());
                    break;
                }
                catch (Exception e) {
                    throw new ConditionException(e);
                }
            }
            case RATE: {
                Condition rCondition;
                try {
                    condition = new RateCondition();
                    rCondition = (RateCondition)condition;
                    if (node.get("dataId") != null) {
                        ((RateCondition)rCondition).setDataId(node.get("dataId").textValue());
                    }
                    if (node.get("direction") != null) {
                        ((RateCondition)rCondition).setDirection(RateCondition.Direction.valueOf(node.get("direction").textValue()));
                    }
                    if (node.get("period") != null) {
                        ((RateCondition)rCondition).setPeriod(RateCondition.Period.valueOf(node.get("period").textValue()));
                    }
                    if (node.get("operator") != null) {
                        ((RateCondition)rCondition).setOperator(RateCondition.Operator.valueOf(node.get("operator").textValue()));
                    }
                    if (node.get("threshold") == null) break;
                    ((RateCondition)rCondition).setThreshold(node.get("threshold").doubleValue());
                    break;
                }
                catch (Exception e) {
                    throw new ConditionException(e);
                }
            }
            default: {
                throw new ConditionException("Unexpected Condition Type [" + conditionType.name() + "]");
            }
        }
        if (condition != null) {
            try {
                if (node.get("tenantId") != null) {
                    condition.setTenantId(node.get("tenantId").textValue());
                }
                if (node.get("triggerId") != null) {
                    condition.setTriggerId(node.get("triggerId").textValue());
                }
                if (node.get("triggerMode") != null) {
                    condition.setTriggerMode(Mode.valueOf(node.get("triggerMode").textValue()));
                }
                if (node.get("conditionSetSize") != null) {
                    condition.setConditionSetSize(node.get("conditionSetSize").intValue());
                }
                if (node.get("conditionSetIndex") != null) {
                    condition.setConditionSetIndex(node.get("conditionSetIndex").intValue());
                }
                if (node.get("context") != null) {
                    condition.setContext(JacksonDeserializer.deserializeMap(node.get("context")));
                }
            }
            catch (Exception e) {
                throw new ConditionException(e);
            }
        }
        return condition;
    }

    public static Map<String, String> deserializeMap(JsonNode mapNode) {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator fieldNames = mapNode.fieldNames();
        while (fieldNames.hasNext()) {
            String field = (String)fieldNames.next();
            map.put(field, mapNode.get(field).asText());
        }
        return map;
    }

    public static class AlertThinDeserializer
    extends BeanDeserializerModifier {
        List<String> ignorables = new ArrayList<String>();

        public AlertThinDeserializer() {
            for (Class clazz = Alert.class; null != clazz; clazz = clazz.getSuperclass()) {
                Field[] fieldArray = clazz.getDeclaredFields();
                int n = fieldArray.length;
                for (int i = 0; i < n; ++i) {
                    Field field = fieldArray[i];
                    if (!field.isAnnotationPresent(Thin.class)) continue;
                    this.ignorables.add(field.getName());
                }
            }
            for (Field field : Action.class.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Thin.class)) continue;
                this.ignorables.add(field.getName());
            }
        }

        public BeanDeserializerBuilder updateBuilder(DeserializationConfig config, BeanDescription beanDesc, BeanDeserializerBuilder builder) {
            if (!beanDesc.getBeanClass().equals(Alert.class) && !beanDesc.getBeanClass().equals(Action.class)) {
                return builder;
            }
            for (String ignore : this.ignorables) {
                builder.addIgnorable(ignore);
            }
            return builder;
        }

        public List<BeanPropertyDefinition> updateProperties(DeserializationConfig config, BeanDescription beanDesc, List<BeanPropertyDefinition> propDefs) {
            if (!beanDesc.getBeanClass().equals(Alert.class) && !beanDesc.getBeanClass().equals(Action.class)) {
                return propDefs;
            }
            ArrayList<BeanPropertyDefinition> newPropDefs = new ArrayList<BeanPropertyDefinition>();
            for (BeanPropertyDefinition propDef : propDefs) {
                if (this.ignorables.contains(propDef.getName())) continue;
                newPropDefs.add(propDef);
            }
            return newPropDefs;
        }
    }

    public static class ConditionEvalException
    extends JsonProcessingException {
        private static final long serialVersionUID = 1L;

        protected ConditionEvalException(String msg, JsonLocation loc, Throwable rootCause) {
            super(msg, loc, rootCause);
        }

        protected ConditionEvalException(String msg) {
            super(msg);
        }

        protected ConditionEvalException(String msg, JsonLocation loc) {
            super(msg, loc);
        }

        protected ConditionEvalException(String msg, Throwable rootCause) {
            super(msg, rootCause);
        }

        protected ConditionEvalException(Throwable rootCause) {
            super(rootCause);
        }
    }

    public static class ConditionException
    extends JsonProcessingException {
        private static final long serialVersionUID = 1L;

        protected ConditionException(String msg, JsonLocation loc, Throwable rootCause) {
            super(msg, loc, rootCause);
        }

        protected ConditionException(String msg) {
            super(msg);
        }

        protected ConditionException(String msg, JsonLocation loc) {
            super(msg, loc);
        }

        protected ConditionException(String msg, Throwable rootCause) {
            super(msg, rootCause);
        }

        protected ConditionException(Throwable rootCause) {
            super(rootCause);
        }
    }

    public static class ConditionEvalDeserializer
    extends JsonDeserializer<ConditionEval> {
        public ConditionEval deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectCodec objectCodec = jp.getCodec();
            JsonNode node = (JsonNode)objectCodec.readTree(jp);
            if (null == node) {
                throw new ConditionEvalException("Unexpected null node.");
            }
            ConditionEval conditionEval = null;
            JsonNode conditionNode = node.get("condition");
            Condition condition = JacksonDeserializer.deserializeCondition(conditionNode);
            switch (condition.getType()) {
                case AVAILABILITY: {
                    try {
                        ConditionEval aConditionEval = conditionEval = new AvailabilityConditionEval();
                        ((AvailabilityConditionEval)aConditionEval).setCondition((AvailabilityCondition)condition);
                        if (node.get("value") == null) break;
                        ((AvailabilityConditionEval)aConditionEval).setValue(AvailabilityType.valueOf(node.get("value").textValue()));
                        break;
                    }
                    catch (Exception e) {
                        throw new ConditionEvalException(e);
                    }
                }
                case COMPARE: {
                    try {
                        conditionEval = new CompareConditionEval();
                        CompareConditionEval cConditionEval = (CompareConditionEval)conditionEval;
                        cConditionEval.setCondition((CompareCondition)condition);
                        if (node.get("value1") != null) {
                            cConditionEval.setValue1(node.get("value1").doubleValue());
                        }
                        if (node.get("value2") != null) {
                            cConditionEval.setValue2(node.get("value2").doubleValue());
                        }
                        if (node.get("context2") == null) break;
                        cConditionEval.setContext2(JacksonDeserializer.deserializeMap(node.get("context2")));
                        break;
                    }
                    catch (Exception e) {
                        throw new ConditionEvalException(e);
                    }
                }
                case EVENT: {
                    try {
                        conditionEval = new EventConditionEval();
                        EventConditionEval evConditionEval = (EventConditionEval)conditionEval;
                        evConditionEval.setCondition((EventCondition)condition);
                        if (node.get("value") == null) break;
                        evConditionEval.setValue((Event)node.get("value").traverse(objectCodec).readValueAs(Event.class));
                        break;
                    }
                    catch (Exception e) {
                        throw new ConditionEvalException(e);
                    }
                }
                case EXTERNAL: {
                    try {
                        conditionEval = new ExternalConditionEval();
                        ExternalConditionEval eConditionEval = (ExternalConditionEval)conditionEval;
                        eConditionEval.setCondition((ExternalCondition)condition);
                        if (node.get("value") == null) break;
                        eConditionEval.setValue(node.get("value").textValue());
                        break;
                    }
                    catch (Exception e) {
                        throw new ConditionEvalException(e);
                    }
                }
                case MISSING: {
                    try {
                        conditionEval = new MissingConditionEval();
                        MissingConditionEval mConditionEval = (MissingConditionEval)conditionEval;
                        mConditionEval.setCondition((MissingCondition)condition);
                        if (node.get("previousTime") != null) {
                            mConditionEval.setPreviousTime(node.get("previousTime").longValue());
                        }
                        if (node.get("time") == null) break;
                        mConditionEval.setTime(node.get("time").longValue());
                        break;
                    }
                    catch (Exception e) {
                        throw new ConditionEvalException(e);
                    }
                }
                case RATE: {
                    ConditionEval rConditionEval;
                    try {
                        conditionEval = new RateConditionEval();
                        rConditionEval = (RateConditionEval)conditionEval;
                        ((RateConditionEval)rConditionEval).setCondition((RateCondition)condition);
                        if (node.get("time") != null) {
                            ((RateConditionEval)rConditionEval).setTime(node.get("time").longValue());
                        }
                        if (node.get("value") != null) {
                            ((RateConditionEval)rConditionEval).setValue(node.get("value").doubleValue());
                        }
                        if (node.get("previousTime") != null) {
                            ((RateConditionEval)rConditionEval).setPreviousTime(node.get("previousTime").longValue());
                        }
                        if (node.get("previousValue") != null) {
                            ((RateConditionEval)rConditionEval).setPreviousValue(node.get("previousValue").doubleValue());
                        }
                        if (node.get("rate") == null) break;
                        ((RateConditionEval)rConditionEval).setRate(node.get("rate").doubleValue());
                        break;
                    }
                    catch (Exception e) {
                        throw new ConditionEvalException(e);
                    }
                }
                case RANGE: {
                    ConditionEval rConditionEval;
                    try {
                        conditionEval = new ThresholdRangeConditionEval();
                        rConditionEval = (ThresholdRangeConditionEval)conditionEval;
                        ((ThresholdRangeConditionEval)rConditionEval).setCondition((ThresholdRangeCondition)condition);
                        if (node.get("value") == null) break;
                        ((ThresholdRangeConditionEval)rConditionEval).setValue(node.get("value").doubleValue());
                        break;
                    }
                    catch (Exception e) {
                        throw new ConditionEvalException(e);
                    }
                }
                case STRING: {
                    try {
                        conditionEval = new StringConditionEval();
                        StringConditionEval sConditionEval = (StringConditionEval)conditionEval;
                        sConditionEval.setCondition((StringCondition)condition);
                        if (node.get("value") == null) break;
                        sConditionEval.setValue(node.get("value").textValue());
                        break;
                    }
                    catch (Exception e) {
                        throw new ConditionEvalException(e);
                    }
                }
                case THRESHOLD: {
                    try {
                        conditionEval = new ThresholdConditionEval();
                        ThresholdConditionEval tConditionEval = (ThresholdConditionEval)conditionEval;
                        tConditionEval.setCondition((ThresholdCondition)condition);
                        if (node.get("value") == null) break;
                        tConditionEval.setValue(node.get("value").doubleValue());
                        break;
                    }
                    catch (Exception e) {
                        throw new ConditionEvalException(e);
                    }
                }
                default: {
                    throw new ConditionEvalException("Unexpected Condition type [" + condition.getType().name() + "]");
                }
            }
            if (conditionEval != null) {
                try {
                    if (node.get("match") != null) {
                        conditionEval.setMatch(node.get("match").booleanValue());
                    }
                    if (node.get("evalTimestamp") != null) {
                        conditionEval.setEvalTimestamp(node.get("evalTimestamp").longValue());
                    }
                    if (node.get("dataTimestamp") != null) {
                        conditionEval.setDataTimestamp(node.get("dataTimestamp").longValue());
                    }
                    if (node.get("context") != null) {
                        conditionEval.setContext(JacksonDeserializer.deserializeMap(node.get("context")));
                    }
                }
                catch (Exception e) {
                    throw new ConditionEvalException(e);
                }
            }
            return conditionEval;
        }
    }

    public static class ConditionDeserializer
    extends JsonDeserializer<Condition> {
        public Condition deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectCodec objectCodec = jp.getCodec();
            JsonNode node = (JsonNode)objectCodec.readTree(jp);
            if (null == node) {
                throw new ConditionException("Unexpected null node.");
            }
            return JacksonDeserializer.deserializeCondition(node);
        }
    }
}

