/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.condition;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hawkular.alerts.api.json.JacksonDeserializer;
import org.hawkular.alerts.api.model.trigger.Mode;

@JsonDeserialize(using=JacksonDeserializer.ConditionDeserializer.class)
public abstract class Condition
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonInclude
    protected String tenantId;
    @JsonInclude
    protected String triggerId;
    @JsonInclude
    protected Mode triggerMode;
    @JsonInclude
    protected Type type;
    @JsonInclude
    protected int conditionSetSize;
    @JsonInclude
    protected int conditionSetIndex;
    @JsonInclude
    protected String conditionId;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected Map<String, String> context;

    public Condition() {
    }

    public Condition(String tenantId, String triggerId, Mode triggerMode, int conditionSetSize, int conditionSetIndex, Type type) {
        this.tenantId = tenantId;
        this.triggerId = triggerId;
        this.triggerMode = triggerMode;
        this.conditionSetSize = conditionSetSize;
        this.conditionSetIndex = conditionSetIndex;
        this.type = type;
        this.updateId();
    }

    public int getConditionSetIndex() {
        return this.conditionSetIndex;
    }

    public void setConditionSetIndex(int conditionSetIndex) {
        this.conditionSetIndex = conditionSetIndex;
        this.updateId();
    }

    public int getConditionSetSize() {
        return this.conditionSetSize;
    }

    public void setConditionSetSize(int conditionSetSize) {
        this.conditionSetSize = conditionSetSize;
        this.updateId();
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
        this.updateId();
    }

    public Mode getTriggerMode() {
        return this.triggerMode;
    }

    public void setTriggerMode(Mode triggerMode) {
        this.triggerMode = triggerMode;
        this.updateId();
    }

    public String getConditionId() {
        return this.conditionId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
        this.updateId();
    }

    public Map<String, String> getContext() {
        if (null == this.context) {
            this.context = new HashMap<String, String>();
        }
        return this.context;
    }

    public void setContext(Map<String, String> context) {
        this.context = context;
    }

    private void updateId() {
        StringBuilder sb = new StringBuilder(this.tenantId);
        sb.append("-").append(this.triggerId);
        sb.append("-").append(this.triggerMode.name());
        sb.append("-").append(this.conditionSetSize);
        sb.append("-").append(this.conditionSetIndex);
        this.conditionId = sb.toString();
    }

    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.conditionId == null ? 0 : this.conditionId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Condition other = (Condition)obj;
        return !(this.conditionId == null ? other.conditionId != null : !this.conditionId.equals(other.conditionId));
    }

    public String toString() {
        return "Condition [tenantId=" + this.tenantId + "triggerId=" + this.triggerId + ", triggerMode=" + (Object)((Object)this.triggerMode) + ", conditionSetSize=" + this.conditionSetSize + ", conditionSetIndex=" + this.conditionSetIndex + "]";
    }

    public abstract String getDataId();

    public static enum Type {
        AVAILABILITY,
        COMPARE,
        STRING,
        THRESHOLD,
        RANGE,
        EXTERNAL,
        EVENT,
        RATE,
        MISSING;

    }
}

