/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.condition;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.trigger.Mode;

public class ExternalCondition
extends Condition {
    private static final long serialVersionUID = 1L;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String alerterId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String dataId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String expression;

    public ExternalCondition() {
        this("", "", Mode.FIRING, 1, 1, null, null, null);
    }

    public ExternalCondition(String triggerId, Mode triggerMode, String dataId, String alerterId, String expression) {
        this("", triggerId, triggerMode, 1, 1, dataId, alerterId, expression);
    }

    public ExternalCondition(String tenantId, String triggerId, Mode triggerMode, String dataId, String alerterId, String expression) {
        this(tenantId, triggerId, triggerMode, 1, 1, dataId, alerterId, expression);
    }

    public ExternalCondition(String triggerId, Mode triggerMode, int conditionSetSize, int conditionSetIndex, String dataId, String alerterId, String expression) {
        this("", triggerId, triggerMode, conditionSetSize, conditionSetIndex, dataId, alerterId, expression);
    }

    public ExternalCondition(String tenantId, String triggerId, Mode triggerMode, int conditionSetSize, int conditionSetIndex, String dataId, String alerterId, String expression) {
        super(tenantId, triggerId, triggerMode, conditionSetSize, conditionSetIndex, Condition.Type.EXTERNAL);
        this.alerterId = alerterId;
        this.dataId = dataId;
        this.expression = expression;
    }

    public String getAlerterId() {
        return this.alerterId;
    }

    public void setAlerterId(String alerterId) {
        this.alerterId = alerterId;
    }

    @Override
    public String getDataId() {
        return this.dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getLog(String value) {
        return this.triggerId + " : " + value + " " + this.expression;
    }

    public boolean match(String value) {
        return true;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.dataId == null ? 0 : this.dataId.hashCode());
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.alerterId == null ? 0 : this.alerterId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExternalCondition other = (ExternalCondition)obj;
        if (this.dataId == null ? other.dataId != null : !this.dataId.equals(other.dataId)) {
            return false;
        }
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        return !(this.alerterId == null ? other.alerterId != null : !this.alerterId.equals(other.alerterId));
    }

    @Override
    public String toString() {
        return "ExternalCondition [alerterId=" + this.alerterId + ", dataId=" + this.dataId + ", expression=" + this.expression + "]";
    }
}

