/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.condition;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.trigger.Mode;

public class MissingCondition
extends Condition {
    private static final long serialVersionUID = 1L;
    @JsonInclude
    private String dataId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private long interval;

    public MissingCondition() {
        this("", "", Mode.FIRING, 1, 1, null, 0L);
    }

    public MissingCondition(String tenantId, String triggerId, String dataId, long interval) {
        this(tenantId, triggerId, Mode.FIRING, 1, 1, dataId, interval);
    }

    public MissingCondition(String tenantId, String triggerId, Mode triggerMode, String dataId, long interval) {
        this(tenantId, triggerId, triggerMode, 1, 1, dataId, interval);
    }

    public MissingCondition(String triggerId, Mode triggerMode, String dataId, long interval) {
        this("", triggerId, triggerMode, 1, 1, dataId, interval);
    }

    public MissingCondition(String tenantId, String triggerId, Mode triggerMode, int conditionSetSize, int conditionSetIndex, String dataId, long interval) {
        super(tenantId, triggerId, null == triggerMode ? Mode.FIRING : triggerMode, conditionSetSize, conditionSetIndex, Condition.Type.MISSING);
        this.dataId = dataId;
        this.interval = interval;
    }

    @Override
    public String getDataId() {
        return this.dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public boolean match(long previousTime, long time) {
        return previousTime + this.interval < time;
    }

    public String getLog(long previousTime, long time) {
        return this.triggerId + " : " + this.dataId + " at " + time + ". Previous time: " + previousTime + " . Interval: " + this.interval;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MissingCondition that = (MissingCondition)o;
        if (this.interval != that.interval) {
            return false;
        }
        return this.dataId != null ? this.dataId.equals(that.dataId) : that.dataId == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.dataId != null ? this.dataId.hashCode() : 0);
        result = 31 * result + (int)(this.interval ^ this.interval >>> 32);
        return result;
    }

    @Override
    public String toString() {
        return "MissingCondition{dataId='" + this.dataId + '\'' + ", interval=" + this.interval + '}';
    }
}

