/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.condition;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.ConditionEval;
import org.hawkular.alerts.api.model.condition.MissingCondition;

public class MissingConditionEval
extends ConditionEval {
    private static final long serialVersionUID = 1L;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private MissingCondition condition;
    @JsonInclude
    private long previousTime;
    @JsonInclude
    private long time;

    public MissingConditionEval() {
        super(Condition.Type.MISSING, false, 0L, null);
        this.previousTime = 0L;
        this.time = 0L;
    }

    public MissingConditionEval(MissingCondition condition, long previousTime, long time) {
        super(Condition.Type.MISSING, condition.match(previousTime, time), time, new HashMap<String, String>());
        this.condition = condition;
        this.previousTime = previousTime;
        this.time = time;
    }

    @Override
    public String getTenantId() {
        return this.condition.getTenantId();
    }

    @Override
    public String getTriggerId() {
        return this.condition.getTriggerId();
    }

    @Override
    public int getConditionSetSize() {
        return this.condition.getConditionSetSize();
    }

    @Override
    public int getConditionSetIndex() {
        return this.condition.getConditionSetIndex();
    }

    @Override
    public String getLog() {
        return this.condition.getLog(this.previousTime, this.time);
    }

    public MissingCondition getCondition() {
        return this.condition;
    }

    public void setCondition(MissingCondition condition) {
        this.condition = condition;
    }

    public long getPreviousTime() {
        return this.previousTime;
    }

    public void setPreviousTime(long previousTime) {
        this.previousTime = previousTime;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MissingConditionEval that = (MissingConditionEval)o;
        if (this.previousTime != that.previousTime) {
            return false;
        }
        if (this.time != that.time) {
            return false;
        }
        return this.condition != null ? this.condition.equals(that.condition) : that.condition == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
        result = 31 * result + (int)(this.previousTime ^ this.previousTime >>> 32);
        result = 31 * result + (int)(this.time ^ this.time >>> 32);
        return result;
    }

    public String toString() {
        return "MissingConditionEval{condition=" + this.condition + ", previousTime=" + this.previousTime + ", time=" + this.time + '}';
    }
}

