/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hawkular.alerts.api.model.data.AvailabilityType;

public class Data
implements Comparable<Data>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SOURCE_NONE = "_none_";
    @JsonInclude
    protected String tenantId;
    @JsonInclude
    protected String source;
    @JsonInclude
    protected String id;
    @JsonInclude
    protected long timestamp;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected String value;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected Map<String, String> context;

    public Data() {
        this(null, 0L, null);
    }

    public Data(String id, long timestamp, String value) {
        this(null, null, id, timestamp, value, null, null);
    }

    public Data(String source, String id, long timestamp, String value) {
        this(null, source, id, timestamp, value, null, null);
    }

    public Data(String tenantId, String source, String id, long timestamp, String value) {
        this(tenantId, source, id, timestamp, value, null, null);
    }

    public Data(String tenantId, String source, String id, long timestamp, String value, Map<String, String> context) {
        this(tenantId, source, id, timestamp, value, null, null);
    }

    public Data(String tenantId, String source, String id, long timestamp, Map<String, String> values) {
        this(tenantId, source, id, timestamp, null, values, null);
    }

    public Data(String tenantId, String source, String id, long timestamp, Map<String, String> values, Map<String, String> context) {
        this(tenantId, source, id, timestamp, null, values, null);
    }

    private Data(String tenantId, String source, String id, long timestamp, String value, Map<String, String> values, Map<String, String> context) {
        this.tenantId = tenantId;
        this.source = this.isEmpty(source) ? SOURCE_NONE : source;
        this.id = id;
        this.timestamp = timestamp <= 0L ? System.currentTimeMillis() : timestamp;
        this.value = value;
        this.context = context;
    }

    public static Data forNumeric(String tenantId, String id, long timestamp, Double value) {
        return new Data(tenantId, null, id, timestamp, String.valueOf(value));
    }

    public static Data forNumeric(String tenantId, String source, String id, long timestamp, Double value) {
        return new Data(tenantId, source, id, timestamp, String.valueOf(value));
    }

    public static Data forNumeric(String tenantId, String id, long timestamp, Double value, Map<String, String> context) {
        return new Data(tenantId, null, id, timestamp, String.valueOf(value), null, context);
    }

    public static Data forNumeric(String tenantId, String source, String id, long timestamp, Double value, Map<String, String> context) {
        return new Data(tenantId, source, id, timestamp, String.valueOf(value), null, context);
    }

    public static Data forString(String tenantId, String id, long timestamp, String value) {
        return new Data(tenantId, null, id, timestamp, value);
    }

    public static Data forString(String tenantId, String source, String id, long timestamp, String value) {
        return new Data(tenantId, source, id, timestamp, value);
    }

    public static Data forString(String tenantId, String id, long timestamp, String value, Map<String, String> context) {
        return new Data(tenantId, null, id, timestamp, value, null, context);
    }

    public static Data forString(String tenantId, String source, String id, long timestamp, String value, Map<String, String> context) {
        return new Data(tenantId, source, id, timestamp, value, null, context);
    }

    public static Data forAvailability(String tenantId, String id, long timestamp, AvailabilityType value) {
        return new Data(tenantId, null, id, timestamp, value.name());
    }

    public static Data forAvailability(String tenantId, String source, String id, long timestamp, AvailabilityType value) {
        return new Data(tenantId, source, id, timestamp, value.name());
    }

    public static Data forAvailability(String tenantId, String id, long timestamp, AvailabilityType value, Map<String, String> context) {
        return new Data(tenantId, null, id, timestamp, value.name(), null, context);
    }

    public static Data forAvailability(String tenantId, String source, String id, long timestamp, AvailabilityType value, Map<String, String> context) {
        return new Data(tenantId, source, id, timestamp, value.name(), null, context);
    }

    private boolean isEmpty(String s) {
        return null == s || s.trim().isEmpty();
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp <= 0L ? System.currentTimeMillis() : timestamp;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Map<String, String> getContext() {
        return this.context;
    }

    public void setContext(Map<String, String> context) {
        this.context = context;
    }

    public void addProperty(String name, String value) {
        if (null == name || null == value) {
            throw new IllegalArgumentException("Property must have non-null name and value");
        }
        if (null == this.context) {
            this.context = new HashMap<String, String>();
        }
        this.context.put(name, value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (this.tenantId == null ? 0 : this.tenantId.hashCode());
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Data other = (Data)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        if (this.tenantId == null ? other.tenantId != null : !this.tenantId.equals(other.tenantId)) {
            return false;
        }
        return this.timestamp == other.timestamp;
    }

    @Override
    public int compareTo(Data o) {
        int c = this.tenantId.compareTo(o.tenantId);
        if (0 != c) {
            return c;
        }
        c = this.source.compareTo(o.source);
        if (0 != c) {
            return c;
        }
        c = this.id.compareTo(o.id);
        if (0 != c) {
            return c;
        }
        return Long.compare(this.timestamp, o.timestamp);
    }

    public boolean same(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Data other = (Data)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        return !(this.tenantId == null ? other.tenantId != null : !this.tenantId.equals(other.tenantId));
    }

    public String toString() {
        return "Data [tenantId=" + this.tenantId + ", id=" + this.id + ", timestamp=" + this.timestamp + ", value=" + this.value + ", context=" + this.context + "]";
    }
}

