/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.event;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.hawkular.alerts.api.model.Severity;
import org.hawkular.alerts.api.model.condition.ConditionEval;
import org.hawkular.alerts.api.model.dampening.Dampening;
import org.hawkular.alerts.api.model.event.Event;
import org.hawkular.alerts.api.model.event.EventType;
import org.hawkular.alerts.api.model.event.Thin;
import org.hawkular.alerts.api.model.trigger.Trigger;

public class Alert
extends Event {
    @JsonInclude
    private Severity severity;
    @JsonInclude
    private Status status;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<Note> notes = new ArrayList<Note>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<LifeCycle> lifecycle = new ArrayList<LifeCycle>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Thin
    private List<Set<ConditionEval>> resolvedEvalSets;

    public Alert() {
        this.eventType = EventType.ALERT.name();
        this.status = Status.OPEN;
    }

    public Alert(String tenantId, Trigger trigger, List<Set<ConditionEval>> evalSets) {
        this(tenantId, trigger, null, evalSets);
    }

    public Alert(String tenantId, Trigger trigger, Dampening dampening, List<Set<ConditionEval>> evalSets) {
        super(tenantId, trigger, dampening, evalSets);
        this.status = Status.OPEN;
        this.severity = trigger.getSeverity();
        this.eventType = EventType.ALERT.name();
        this.addLifecycle(this.status, "system", this.ctime);
    }

    @JsonIgnore
    public String getAlertId() {
        return this.id;
    }

    public void setAlertId(String alertId) {
        this.id = alertId;
    }

    @JsonIgnore
    public String getTriggerId() {
        return this.getTrigger().getId();
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public List<Set<ConditionEval>> getResolvedEvalSets() {
        return this.resolvedEvalSets;
    }

    public void setResolvedEvalSets(List<Set<ConditionEval>> resolvedEvalSets) {
        this.resolvedEvalSets = resolvedEvalSets;
    }

    public List<Note> getNotes() {
        return this.notes;
    }

    public void setNotes(List<Note> notes) {
        this.notes = notes;
    }

    public void addNote(String user, String text) {
        if (user == null || text == null) {
            throw new IllegalArgumentException("Note must have non-null user and text");
        }
        this.getNotes().add(new Note(user, text));
    }

    public List<LifeCycle> getLifecycle() {
        return this.lifecycle;
    }

    public void setLifecycle(List<LifeCycle> lifecycle) {
        this.lifecycle = lifecycle;
    }

    public void addLifecycle(Status status, String user, long stime) {
        if (status == null || user == null) {
            throw new IllegalArgumentException("Lifecycle must have non-null state and user");
        }
        this.setStatus(status);
        this.getLifecycle().add(new LifeCycle(status, user, stime));
    }

    @JsonIgnore
    public LifeCycle getCurrentLifecycle() {
        if (this.getLifecycle().isEmpty()) {
            return null;
        }
        return this.getLifecycle().get(this.getLifecycle().size() - 1);
    }

    @JsonIgnore
    public Long getLastStatusTime(Status status) {
        if (this.getLifecycle().isEmpty()) {
            return null;
        }
        Long statusTime = null;
        ListIterator<LifeCycle> iterator = this.getLifecycle().listIterator(this.getLifecycle().size());
        while (iterator.hasPrevious()) {
            LifeCycle lifeCycle = iterator.previous();
            if (!lifeCycle.getStatus().equals((Object)status)) continue;
            statusTime = lifeCycle.getStime();
            break;
        }
        return statusTime;
    }

    @JsonIgnore
    public Long getLastOpenTime() {
        return this.getLastStatusTime(Status.OPEN);
    }

    @JsonIgnore
    public Long getLastAckTime() {
        return this.getLastStatusTime(Status.ACKNOWLEDGED);
    }

    @JsonIgnore
    public Long getLastResolvedTime() {
        return this.getLastStatusTime(Status.RESOLVED);
    }

    @Override
    public String toString() {
        return "Alert{severity=" + (Object)((Object)this.severity) + ", status=" + (Object)((Object)this.status) + ", notes=" + this.notes + ", lifecycle=" + this.lifecycle + ", resolvedEvalSets=" + this.resolvedEvalSets + '}';
    }

    public static class LifeCycle {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private Status status;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private String user;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private long stime;

        public LifeCycle() {
        }

        public LifeCycle(Status status, String user, long stime) {
            this.status = status;
            this.user = user;
            this.stime = stime;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public Status getStatus() {
            return this.status;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public long getStime() {
            return this.stime;
        }

        public void setStime(long stime) {
            this.stime = stime;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LifeCycle lifeCycle = (LifeCycle)o;
            if (this.stime != lifeCycle.stime) {
                return false;
            }
            if (this.user != null ? !this.user.equals(lifeCycle.user) : lifeCycle.user != null) {
                return false;
            }
            return this.status == lifeCycle.status;
        }

        public int hashCode() {
            int result = this.user != null ? this.user.hashCode() : 0;
            result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
            result = 31 * result + (int)(this.stime ^ this.stime >>> 32);
            return result;
        }

        public String toString() {
            return "LifeCycle{user='" + this.user + '\'' + ", status=" + (Object)((Object)this.status) + ", stime=" + this.stime + '}';
        }
    }

    public static class Note {
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private String user;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private long ctime;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private String text;

        public Note() {
        }

        public Note(String user, String text) {
            this(user, System.currentTimeMillis(), text);
        }

        public Note(String user, long ctime, String text) {
            this.user = user;
            this.ctime = ctime;
            this.text = text;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public long getCtime() {
            return this.ctime;
        }

        public void setCtime(long ctime) {
            this.ctime = ctime;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Note note = (Note)o;
            if (this.ctime != note.ctime) {
                return false;
            }
            if (this.user != null ? !this.user.equals(note.user) : note.user != null) {
                return false;
            }
            return !(this.text == null ? note.text != null : !this.text.equals(note.text));
        }

        public int hashCode() {
            int result = this.user != null ? this.user.hashCode() : 0;
            result = 31 * result + (int)(this.ctime ^ this.ctime >>> 32);
            result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Note{user='" + this.user + '\'' + ", ctime=" + this.ctime + ", text='" + this.text + '\'' + '}';
        }
    }

    public static enum Status {
        OPEN,
        ACKNOWLEDGED,
        RESOLVED;

    }
}

