/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.json;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Map;

@ApiModel(description="A convenience class used in the REST API to POST a new group Member Trigger. + \n + \nA group-level condition uses dataId tokens for the dataIds defined in the condition. + \nThe group members must then replace the tokens with actual dataIds. + \n + \nFor example, we may define a group ThresholdCondition like ( $SystemLoad$ > 80 ). + \nEach member must then replace $SystemLoad$ with the actual system load dataId for that member. + \nThe dataIdMap is a map of the dataId tokens in the group conditions to the actual dataIds to + \nbe used for the member being added. For example, assume the group trigger has two conditions defined: + \n + \nThresholdCondition( $SystemLoad$ > 80 ) and ThresholdCondition( $HeapUsed$ > 70 ) + \n + \nAnd now let's assume we are adding a new member, Member1.  The map would look like this: + \n + \n{ \"$SystemLoad$\":\"Member1SystemLoad\", \"$HeapUsed$\":\"Member1HeapUsed\" } + \n + \nSo, in the example the actual dataIds would be Member1SystemLoad and Member1HeapUsed. + \nWith this Map we can now add the new member trigger. + \n + \nA NOTE ABOUT EXTERNAL CONDITIONS. ExternalCondition.expression will automatically have the + \nsame token replacement performed. So, all occurrences of the dataId token found in the expression, + \nwill be replaced with the mapping. + \nThis allows the expression of a group external condition to be automatically customized to the member.")
public class GroupMemberInfo {
    @ApiModelProperty(value="Trigger id for parent Group Trigger.", position=0, required=true)
    private String groupId;
    @ApiModelProperty(value="Trigger id for member Trigger.", position=1, required=true)
    private String memberId;
    @ApiModelProperty(value="Trigger name for member Trigger.", position=2, required=true)
    private String memberName;
    @ApiModelProperty(value="Trigger name for member Trigger.", position=3, required=true)
    private String memberDescription;
    @ApiModelProperty(value="Trigger context for member Trigger.", position=4, required=true)
    private Map<String, String> memberContext;
    @ApiModelProperty(value="Trigger tags for member Trigger.", position=5, required=true)
    private Map<String, String> memberTags;
    @ApiModelProperty(value="A map of the dataId tokens in the group conditions to the actual dataIds to be used for the member being added. + \nCan be empty if the group has no current conditions.", position=6, required=true)
    private Map<String, String> dataIdMap;

    public GroupMemberInfo() {
    }

    public GroupMemberInfo(String groupId, String memberId, String memberName, String memberDescription, Map<String, String> memberContext, Map<String, String> memberTags, Map<String, String> dataIdMap) {
        this.groupId = groupId;
        this.memberId = memberId;
        this.memberName = memberName;
        this.memberDescription = memberDescription;
        this.memberContext = memberContext;
        this.memberTags = memberTags;
        this.dataIdMap = dataIdMap;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    public String getMemberDescription() {
        return this.memberDescription;
    }

    public void setMemberDescription(String memberDescription) {
        this.memberDescription = memberDescription;
    }

    public Map<String, String> getMemberContext() {
        return this.memberContext;
    }

    public void setMemberContext(Map<String, String> memberContext) {
        this.memberContext = memberContext;
    }

    public Map<String, String> getMemberTags() {
        return this.memberTags;
    }

    public void setMemberTags(Map<String, String> memberTags) {
        this.memberTags = memberTags;
    }

    public Map<String, String> getDataIdMap() {
        return this.dataIdMap;
    }

    public void setDataIdMap(Map<String, String> dataIdMap) {
        this.dataIdMap = dataIdMap;
    }

    public String toString() {
        return "GroupMemberInfo [groupId=" + this.groupId + ", memberId=" + this.memberId + ", memberName=" + this.memberName + ", memberContext=" + this.memberContext + ", dataIdMap=" + this.dataIdMap + "]";
    }
}

