/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.json;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Map;

@ApiModel(description="A convenience class used in the REST API to un-orphan an orphan group Member Trigger. + \n + \nA group-level condition uses dataId tokens for the dataIds defined in the condition. + \nThe group members must then replace the tokens with actual dataIds. + \n + \nFor example, we may define a group ThresholdCondition like ( $SystemLoad$ > 80 ). + \nEach member must then replace $SystemLoad$ with the actual system load dataId for that member. + \nThe dataIdMap is a map of the dataId tokens in the group conditions to the actual dataIds to + \nbe used for the member being added. For example, assume the group trigger has two conditions defined: + \n + \nThresholdCondition( $SystemLoad$ > 80 ) and ThresholdCondition( $HeapUsed$ > 70 ) + \n + \nAnd now let's assume we are adding a new member, Member1.  The map would look like this: + \n + \n{ \"$SystemLoad$\":\"Member1SystemLoad\", \"$HeapUsed$\":\"Member1HeapUsed\" } + \n + \nSo, in the example the actual dataIds would be Member1SystemLoad and Member1HeapUsed. + \nWith this Map we can now add the new member trigger. + \n + \nA NOTE ABOUT EXTERNAL CONDITIONS. ExternalCondition.expression will automatically have the + \nsame token replacement performed. So, all occurrences of the dataId token found in the expression, + \nwill be replaced with the mapping. + \nThis allows the expression of a group external condition to be automatically customized to the member.")
public class UnorphanMemberInfo {
    @ApiModelProperty(value="Trigger context for member Trigger.", position=1, required=true)
    private Map<String, String> memberContext;
    @ApiModelProperty(value="Trigger tags for member Trigger.", position=2, required=true)
    private Map<String, String> memberTags;
    @ApiModelProperty(value="A map of the dataId tokens in the group conditions to the actual dataIds to be used for the member being added. + \nCan be empty if the group has no current conditions.", position=3, required=true)
    private Map<String, String> dataIdMap;

    public UnorphanMemberInfo() {
    }

    public UnorphanMemberInfo(Map<String, String> memberContext, Map<String, String> memberTags, Map<String, String> dataIdMap) {
        this.memberContext = memberContext;
        this.memberTags = memberTags;
        this.dataIdMap = dataIdMap;
    }

    public Map<String, String> getMemberContext() {
        return this.memberContext;
    }

    public void setMemberContext(Map<String, String> memberContext) {
        this.memberContext = memberContext;
    }

    public Map<String, String> getMemberTags() {
        return this.memberTags;
    }

    public void setMemberTags(Map<String, String> memberTags) {
        this.memberTags = memberTags;
    }

    public Map<String, String> getDataIdMap() {
        return this.dataIdMap;
    }

    public void setDataIdMap(Map<String, String> dataIdMap) {
        this.dataIdMap = dataIdMap;
    }

    public String toString() {
        return "UnorphanMemberInfo [memberContext=" + this.memberContext + ", dataIdMap=" + this.dataIdMap + "]";
    }
}

