/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.action;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hawkular.alerts.api.model.action.TimeConstraint;

@ApiModel(description="An action represents a consequence of an event. + \n + \nActions are processed by plugins, and plugins offer a map of properties to personalize an action. + \nAn ActionDefinition stores which properties will be used for a specific action in a specific plugin. + \n + \nA Trigger definition can be linked with a list of action definitions. + \n + \nAlert engine will instantiate a specific Action based on its ActionDefinition. + \n + \nIn a similar way as <<TriggerAction>> an ActionDefinition can add optional constraints that determine + \nwhen an action will be executed. + \n + \n- A set of Alert.Status (represented by its string value). + \nThe action will be executed if the Alert which is linked is on one of the states defined. + \nUnlike Alerts, Events don't have lifecycle, TriggerActions on Events are all executed at Event creation time. + \n + \n- A <<TimeConstraint>> object that defines a time interval in absolute or relative way. + \nThe action will be executed if the action creation time is satisfied by the time interval. + \nIf a <<TriggerAction>> does not define any constraint, <<ActionDefinition>> constraints will be used. + \n")
public class ActionDefinition
implements Serializable {
    @ApiModelProperty(value="Tenant id owner of this trigger.", position=0, allowableValues="Tenant is overwritten from Hawkular-Tenant HTTP header parameter request")
    @JsonInclude
    private String tenantId;
    @ApiModelProperty(value="Action plugin identifier.", position=1, required=true, allowableValues="Only plugins deployed on the system are valid.")
    @JsonInclude
    private String actionPlugin;
    @ApiModelProperty(value="Action definition identifier.", position=2, required=true)
    @JsonInclude
    private String actionId;
    @ApiModelProperty(value="Flag to indicate this is a global action.", position=3, required=false)
    @JsonInclude
    private boolean global;
    @ApiModelProperty(value="Plugin properties. Each plugin defines its own specific properties that can be supplied at action definition level.", position=4, required=true)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, String> properties;
    @ApiModelProperty(value="A list of Alert.Status where this action is linked. <<TriggerAction>> constraints take precedence.", position=5, allowableValues="OPEN, ACKNOWLEDGED, RESOLVED")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Set<String> states;
    @ApiModelProperty(value="A list of TimeConstraint where this action is linked. <<TriggerAction>> constraints take precedence.", position=6)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private TimeConstraint calendar;

    public ActionDefinition() {
        this(null, null, null, false, new HashMap<String, String>(), null, null);
    }

    public ActionDefinition(String tenantId, String actionPlugin, String actionId) {
        this(tenantId, actionPlugin, actionId, false, new HashMap<String, String>(), null, null);
    }

    public ActionDefinition(String tenantId, String actionPlugin, String actionId, Map<String, String> properties) {
        this(tenantId, actionPlugin, actionId, false, properties, null, null);
    }

    public ActionDefinition(String tenantId, String actionPlugin, String actionId, boolean global, Map<String, String> properties, Set<String> states, TimeConstraint calendar) {
        this.tenantId = tenantId;
        this.actionPlugin = actionPlugin;
        this.actionId = actionId;
        this.global = global;
        this.properties = properties != null ? new HashMap<String, String>(properties) : new HashMap();
        this.states = states != null ? new HashSet<String>(states) : new HashSet();
        this.calendar = calendar;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getActionPlugin() {
        return this.actionPlugin;
    }

    public void setActionPlugin(String actionPlugin) {
        this.actionPlugin = actionPlugin;
    }

    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Set<String> getStates() {
        if (this.states == null) {
            this.states = new HashSet<String>();
        }
        return this.states;
    }

    public void setStates(Set<String> states) {
        this.states = states;
    }

    public void addState(String state) {
        this.getStates().add(state);
    }

    public TimeConstraint getCalendar() {
        return this.calendar;
    }

    public void setCalendar(TimeConstraint calendar) {
        this.calendar = calendar;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionDefinition that = (ActionDefinition)o;
        if (this.global != that.global) {
            return false;
        }
        if (this.tenantId != null ? !this.tenantId.equals(that.tenantId) : that.tenantId != null) {
            return false;
        }
        if (this.actionPlugin != null ? !this.actionPlugin.equals(that.actionPlugin) : that.actionPlugin != null) {
            return false;
        }
        if (this.actionId != null ? !this.actionId.equals(that.actionId) : that.actionId != null) {
            return false;
        }
        if (this.properties != null ? !this.properties.equals(that.properties) : that.properties != null) {
            return false;
        }
        if (this.states != null ? !this.states.equals(that.states) : that.states != null) {
            return false;
        }
        return this.calendar != null ? this.calendar.equals(that.calendar) : that.calendar == null;
    }

    public int hashCode() {
        int result = this.tenantId != null ? this.tenantId.hashCode() : 0;
        result = 31 * result + (this.actionPlugin != null ? this.actionPlugin.hashCode() : 0);
        result = 31 * result + (this.actionId != null ? this.actionId.hashCode() : 0);
        result = 31 * result + (this.global ? 1 : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        result = 31 * result + (this.states != null ? this.states.hashCode() : 0);
        result = 31 * result + (this.calendar != null ? this.calendar.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ActionDefinition{tenantId='" + this.tenantId + '\'' + ", actionPlugin='" + this.actionPlugin + '\'' + ", actionId='" + this.actionId + '\'' + ", global=" + this.global + ", properties=" + this.properties + ", states=" + this.states + ", calendar=" + this.calendar + '}';
    }
}

