/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.condition;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.data.Data;
import org.hawkular.alerts.api.model.trigger.Mode;

@ApiModel(description="A condition to detect instability based on historical data. + \n + \nFrom one to all of the defined Nelson rules can be evaluated. See + \nhttps://en.wikipedia.org/wiki/Nelson_rules for a description of the rules.")
public class NelsonCondition
extends Condition {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_SAMPLE_SIZE = 50;
    private static final Set<NelsonRule> DEFAULT_ACTIVE_RULES = EnumSet.allOf(NelsonRule.class);
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String dataId;
    @ApiModelProperty(value="Set of NelsonRule to evaluate.", position=1, example="All Rules", required=false)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Set<NelsonRule> activeRules;
    @ApiModelProperty(value="Number of samples used to establish baseline information (mean, standard deviation).", position=2, example="50", required=false)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private int sampleSize;

    public NelsonCondition() {
        this("", "", Mode.FIRING, 1, 1, null, null, null);
    }

    public NelsonCondition(String tenantId, String triggerId, String dataId) {
        this(tenantId, triggerId, Mode.FIRING, 1, 1, dataId, null, null);
    }

    public NelsonCondition(String tenantId, String triggerId, String dataId, Set<NelsonRule> activeRules) {
        this(tenantId, triggerId, Mode.FIRING, 1, 1, dataId, activeRules, null);
    }

    public NelsonCondition(String tenantId, String triggerId, String dataId, Set<NelsonRule> activeRules, Integer sampleSize) {
        this(tenantId, triggerId, Mode.FIRING, 1, 1, dataId, activeRules, sampleSize);
    }

    public NelsonCondition(String triggerId, String dataId, Set<NelsonRule> activeRules) {
        this("", triggerId, Mode.FIRING, 1, 1, dataId, activeRules, null);
    }

    public NelsonCondition(String triggerId, String dataId, Set<NelsonRule> activeRules, Integer sampleSize) {
        this("", triggerId, Mode.FIRING, 1, 1, dataId, activeRules, sampleSize);
    }

    public NelsonCondition(String triggerId, Mode triggerMode, int conditionSetSize, int conditionSetIndex, String dataId, Set<NelsonRule> activeRules, Integer sampleSize) {
        this("", triggerId, triggerMode, conditionSetSize, conditionSetIndex, dataId, activeRules, sampleSize);
    }

    public NelsonCondition(String tenantId, String triggerId, Mode triggerMode, int conditionSetSize, int conditionSetIndex, String dataId, Set<NelsonRule> activeRules, Integer sampleSize) {
        super(tenantId, triggerId, null == triggerMode ? Mode.FIRING : triggerMode, conditionSetSize, conditionSetIndex, Condition.Type.NELSON);
        this.dataId = dataId;
        this.setActiveRules(activeRules);
        this.setSampleSize(sampleSize);
    }

    @Override
    public String getDataId() {
        return this.dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public Set<NelsonRule> getActiveRules() {
        return this.activeRules;
    }

    public void setActiveRules(Set<NelsonRule> activeRules) {
        this.activeRules = null == activeRules || activeRules.isEmpty() ? DEFAULT_ACTIVE_RULES : activeRules;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(Integer sampleSize) {
        this.sampleSize = null == sampleSize || sampleSize < 1 ? 50 : sampleSize;
    }

    public String getLog(List<NelsonRule> violations, Double mean, Double standardDeviation, List<Data> violationsData) {
        StringBuilder sb = new StringBuilder(this.triggerId);
        sb.append(" : ");
        sb.append(violations);
        sb.append(", mean= ");
        sb.append(mean);
        sb.append(", standardDeviation=");
        sb.append(standardDeviation);
        sb.append(", sampleSize=");
        sb.append(this.sampleSize);
        sb.append(", violationsData=");
        sb.append(violationsData);
        return sb.toString();
    }

    public boolean match(List<NelsonRule> violations) {
        if (this.isEmpty(violations) || this.isEmpty(this.activeRules)) {
            return false;
        }
        for (NelsonRule r : violations) {
            if (!this.activeRules.contains((Object)r)) continue;
            return true;
        }
        return false;
    }

    private boolean isEmpty(Collection<?> c) {
        return null == c || c.isEmpty();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.activeRules == null ? 0 : this.activeRules.hashCode());
        result = 31 * result + (this.dataId == null ? 0 : this.dataId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NelsonCondition other = (NelsonCondition)obj;
        if (this.activeRules == null ? other.activeRules != null : !this.activeRules.equals(other.activeRules)) {
            return false;
        }
        return !(this.dataId == null ? other.dataId != null : !this.dataId.equals(other.dataId));
    }

    @Override
    public String toString() {
        return "NelsonCondition [dataId=" + this.dataId + ", activeRules=" + this.activeRules + "]";
    }

    public static enum NelsonRule {
        Rule1("One point is more than 3 standard deviations from the mean"),
        Rule2("Nine (or more) points in a row are on the same side of the mean."),
        Rule3("Six (or more) points in a row are continually increasing (or decreasing)."),
        Rule4("Fourteen (or more) points in a row alternate in direction, increasing then decreasing."),
        Rule5("At least 2 of 3 points in a row are > 2 standard deviations from the mean in the same direction."),
        Rule6("At least 4 of 5 points in a row are > 1 standard deviation from the mean in the same direction."),
        Rule7("Fifteen points in a row are all within 1 standard deviation of the mean on either side of the mean."),
        Rule8("Eight points in a row exist, but none within 1 standard deviation of the mean, and the points are in both directions from the mean.");

        private String description;

        private NelsonRule(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

