/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.condition;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.trigger.Mode;

@ApiModel(description="A threshold condition against rate of change over time. + \n + \nTypically used for \"counter\" metrics, that continuously increase or decrease. + \nGiven the last two datums for dataId: + \n + \ndeltaTime   = datum.time - prevDatum.time + \ndeltaValue  = datum.value - prevData.value + \nperiods     = deltaTime / <conditionPeriod> + \nrate        = deltaValue / periods + \nmatch       = rate <conditionOperator> <conditionThreshold> + \n + \nIn other words, take the rate of change for the most recent datums and compare it to the threshold. + \nFor example, + \nLet's say we have a metric, sessionCount, that increments for each new session.  If the sessionCount increases too quickly, say more than 20 per minute, we want an alert.  We'd want: + \n + \nRateCondition( 'SessionCount', INCREASING, MINUTE, GT, 20 ) + \n + \nBy specifying the SessionCount data as increasing, we know to ignore/reset if the previous session count is less than the current session count.  This indicates that maybe the counter was reset (maybe due to a restart). + \n + \nNote that rate of change is always determined as an absolute value. So threshold values should be >= 0.")
public class RateCondition
extends Condition {
    private static final long serialVersionUID = 1L;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String dataId;
    @ApiModelProperty(value="Indicate if a metric is increasing/decreasing.", position=0, required=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Direction direction;
    @ApiModelProperty(value="Time period used for the evaluation.", position=1, required=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Period period;
    @ApiModelProperty(value="Compare operator [LT (<), GT (>), LTE (<=), GTE (>=)].", position=2, required=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Operator operator;
    @ApiModelProperty(value="Condition threshold.", position=3, required=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Double threshold;

    public RateCondition() {
        this("", "", Mode.FIRING, 1, 1, null, null, null, null, null);
    }

    public RateCondition(String tenantId, String triggerId, String dataId, Direction direction, Period period, Operator operator, Double threshold) {
        this(tenantId, triggerId, Mode.FIRING, 1, 1, dataId, direction, period, operator, threshold);
    }

    public RateCondition(String triggerId, Mode triggerMode, String dataId, Direction direction, Period period, Operator operator, Double threshold) {
        this("", triggerId, triggerMode, 1, 1, dataId, direction, period, operator, threshold);
    }

    public RateCondition(String tenantId, String triggerId, Mode triggerMode, String dataId, Direction direction, Period period, Operator operator, Double threshold) {
        this(tenantId, triggerId, triggerMode, 1, 1, dataId, direction, period, operator, threshold);
    }

    public RateCondition(String triggerId, Mode triggerMode, int conditionSetSize, int conditionSetIndex, String dataId, Direction direction, Period period, Operator operator, Double threshold) {
        this("", triggerId, triggerMode, conditionSetSize, conditionSetIndex, dataId, direction, period, operator, threshold);
    }

    public RateCondition(String tenantId, String triggerId, Mode triggerMode, int conditionSetSize, int conditionSetIndex, String dataId, Direction direction, Period period, Operator operator, Double threshold) {
        super(tenantId, triggerId, null == triggerMode ? Mode.FIRING : triggerMode, conditionSetSize, conditionSetIndex, Condition.Type.RATE);
        this.dataId = dataId;
        this.direction = null == direction ? Direction.INCREASING : direction;
        this.period = null == period ? Period.MINUTE : period;
        this.operator = operator;
        this.threshold = threshold;
    }

    @Override
    public String getDataId() {
        return this.dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public Double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Double threshold) {
        this.threshold = threshold;
    }

    public String getLog(long time, double value, long previousTime, double previousValue) {
        long deltaTime = time - previousTime;
        double deltaValue = Direction.INCREASING == this.direction ? value - previousValue : previousValue - value;
        double periods = deltaTime / this.period.milliseconds;
        double rate = deltaValue / periods;
        return this.triggerId + " : " + (Object)((Object)this.direction) + " " + rate + " " + this.operator.name() + " " + this.threshold + " per " + (Object)((Object)this.period);
    }

    public boolean match(long time, double value, long previousTime, double previousValue) {
        double rate = this.getRate(time, value, previousTime, previousValue);
        if (rate < 0.0) {
            return false;
        }
        switch (this.operator) {
            case LT: {
                return rate < this.threshold;
            }
            case GT: {
                return rate > this.threshold;
            }
            case LTE: {
                return rate <= this.threshold;
            }
            case GTE: {
                return rate >= this.threshold;
            }
        }
        throw new IllegalStateException("Unknown operator: " + this.operator.name());
    }

    public double getRate(long time, double value, long previousTime, double previousValue) {
        double deltaTime = time - previousTime;
        double deltaValue = Direction.INCREASING == this.direction ? value - previousValue : previousValue - value;
        double periods = deltaTime / (double)this.period.milliseconds;
        double rate = deltaValue / periods;
        return rate;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.dataId == null ? 0 : this.dataId.hashCode());
        result = 31 * result + (this.direction == null ? 0 : this.direction.hashCode());
        result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
        result = 31 * result + (this.period == null ? 0 : this.period.hashCode());
        result = 31 * result + (this.threshold == null ? 0 : this.threshold.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RateCondition other = (RateCondition)obj;
        if (this.dataId == null ? other.dataId != null : !this.dataId.equals(other.dataId)) {
            return false;
        }
        if (this.direction != other.direction) {
            return false;
        }
        if (this.operator != other.operator) {
            return false;
        }
        if (this.period != other.period) {
            return false;
        }
        return !(this.threshold == null ? other.threshold != null : !this.threshold.equals(other.threshold));
    }

    @Override
    public String toString() {
        return "RateCondition [dataId=" + this.dataId + ", direction=" + (Object)((Object)this.direction) + ", period=" + (Object)((Object)this.period) + ", operator=" + (Object)((Object)this.operator) + ", threshold=" + this.threshold + ", tenantId=" + this.tenantId + ", triggerId=" + this.triggerId + ", triggerMode=" + (Object)((Object)this.triggerMode) + "]";
    }

    public static enum Direction {
        DECREASING,
        INCREASING,
        NA;

    }

    public static enum Period {
        SECOND(1000L),
        MINUTE(60000L),
        HOUR(3600000L),
        DAY(86400000L),
        WEEK(604800000L);

        public long milliseconds;

        private Period(long milliseconds) {
            this.milliseconds = milliseconds;
        }
    }

    public static enum Operator {
        LT,
        GT,
        LTE,
        GTE;

    }
}

