/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.dampening;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hawkular.alerts.api.model.condition.ConditionEval;
import org.hawkular.alerts.api.model.trigger.Match;
import org.hawkular.alerts.api.model.trigger.Mode;

@ApiModel(description="A representation of dampening status. + \n + \nIt\u2019s often the case that you don\u2019t want a trigger to fire every time a condition set is met. + \nInstead, you want to ensure that the issue is not a spike of activity. + \nHawkular Alerting provides several ways of ensuring triggers fire only as desired. + \n + \nThis is a Trigger Dampening in Hawkular Alerting terminology. + \n + \nDampening types: + \n + \nSTRICT + \n + \n- N consecutive true evaluations. + \n- Useful for ignoring spikes in activity or waiting for a prolonged event. + \n + \nRELAXED_COUNT + \n + \n- N true evaluations out of M total evaluations. + \n- Useful for ignoring short spikes in activity but catching frequently spiking activity. + \n + \nRELAXED_TIME + \n + \n- N true evaluations in T time. + \n- Useful for ignoring short spikes in activity but catching frequently spiking activity. \n + \nSTRICT_TIME + \n + \n- Only true evaluations for at least T time. + \n- Useful for reporting a continued aberration. + \n + \nSTRICT_TIMEOUT + \n + \n- Only true evaluations for T time. + \n- Useful for reporting a continued aberration with a more guaranteed firing time. + \n")
public class Dampening
implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value="Tenant id owner of this dampening.", position=0, required=false, allowableValues="Tenant is overwritten from Hawkular-Tenant HTTP header parameter request")
    @JsonInclude
    private String tenantId;
    @ApiModelProperty(value="The owning trigger.", position=1, allowableValues="triggerId is set up from REST request parameters")
    @JsonInclude
    private String triggerId;
    @ApiModelProperty(value="The owning trigger's mode when this dampening is active.", position=2, required=true)
    @JsonInclude
    private Mode triggerMode;
    @ApiModelProperty(value="The type of the dampening.", position=3, required=true)
    @JsonInclude
    private Type type;
    @JsonInclude
    @ApiModelProperty(value="Number of required true evaluations for STRICT, RELAXED_COUNT, RELAXED_TIME", position=4, allowableValues=">= 1")
    private int evalTrueSetting;
    @JsonInclude
    @ApiModelProperty(value="Number of allowed evaluation attempts for RELAXED_COUNT", position=5, allowableValues="> evalTrueSetting")
    private int evalTotalSetting;
    @JsonInclude
    @ApiModelProperty(value="Time period in milliseconds for RELAXED_TIME, STRICT_TIME, STRICT_TIMEOUT", position=6, allowableValues="> 0")
    private long evalTimeSetting;
    @ApiModelProperty(value="A composed key for the dampening. This is a read-only value defined by the system.", position=7, required=false)
    @JsonInclude
    protected String dampeningId;
    @JsonIgnore
    private transient int numTrueEvals;
    @JsonIgnore
    private transient int numEvals;
    @JsonIgnore
    private transient long trueEvalsStartTime;
    @JsonIgnore
    private transient Map<Integer, ConditionEval> currentEvals = new HashMap<Integer, ConditionEval>(5);
    @JsonIgnore
    private transient boolean satisfied;
    @JsonIgnore
    private transient List<Set<ConditionEval>> satisfyingEvals = new ArrayList<Set<ConditionEval>>();

    public Dampening() {
        this("", "", Mode.FIRING, Type.STRICT, 1, 1, 0L);
    }

    public static Dampening forStrict(String tenantId, String triggerId, Mode triggerMode, int numConsecutiveTrueEvals) {
        if (numConsecutiveTrueEvals < 1) {
            throw new IllegalArgumentException("NumConsecutiveTrueEvals must be >= 1");
        }
        return new Dampening(tenantId, triggerId, triggerMode, Type.STRICT, numConsecutiveTrueEvals, numConsecutiveTrueEvals, 0L);
    }

    public static Dampening forRelaxedCount(String tenantId, String triggerId, Mode triggerMode, int numTrueEvals, int numTotalEvals) {
        if (numTrueEvals < 1) {
            throw new IllegalArgumentException("NumTrueEvals must be >= 1");
        }
        if (numTotalEvals <= numTrueEvals) {
            throw new IllegalArgumentException("NumTotalEvals must be > NumTrueEvals");
        }
        return new Dampening(tenantId, triggerId, triggerMode, Type.RELAXED_COUNT, numTrueEvals, numTotalEvals, 0L);
    }

    public static Dampening forRelaxedTime(String tenantId, String triggerId, Mode triggerMode, int numTrueEvals, long evalPeriod) {
        if (numTrueEvals < 1) {
            throw new IllegalArgumentException("NumTrueEvals must be >= 1");
        }
        if (evalPeriod < 1L) {
            throw new IllegalArgumentException("EvalPeriod must be >= 1ms");
        }
        return new Dampening(tenantId, triggerId, triggerMode, Type.RELAXED_TIME, numTrueEvals, 0, evalPeriod);
    }

    public static Dampening forStrictTime(String tenantId, String triggerId, Mode triggerMode, long evalPeriod) {
        if (evalPeriod < 1L) {
            throw new IllegalArgumentException("EvalPeriod must be >= 1ms");
        }
        return new Dampening(tenantId, triggerId, triggerMode, Type.STRICT_TIME, 0, 0, evalPeriod);
    }

    public static Dampening forStrictTimeout(String tenantId, String triggerId, Mode triggerMode, long evalPeriod) {
        if (evalPeriod < 1L) {
            throw new IllegalArgumentException("EvalPeriod must be >= 1ms");
        }
        return new Dampening(tenantId, triggerId, triggerMode, Type.STRICT_TIMEOUT, 0, 0, evalPeriod);
    }

    public Dampening(String tenantId, String triggerId, Mode triggerMode, Type type, int evalTrueSetting, int evalTotalSetting, long evalTimeSetting) {
        this.tenantId = tenantId;
        this.triggerId = triggerId;
        this.type = type;
        this.evalTrueSetting = evalTrueSetting;
        this.evalTotalSetting = evalTotalSetting;
        this.evalTimeSetting = evalTimeSetting;
        this.triggerMode = triggerMode;
        this.updateId();
        this.reset();
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
        this.updateId();
    }

    public Mode getTriggerMode() {
        return this.triggerMode;
    }

    public void setTriggerMode(Mode triggerMode) {
        this.triggerMode = triggerMode;
        this.updateId();
    }

    public void setEvalTimeSetting(long evalTimeSetting) {
        this.evalTimeSetting = evalTimeSetting;
    }

    public void setEvalTotalSetting(int evalTotalSetting) {
        this.evalTotalSetting = evalTotalSetting;
    }

    public void setEvalTrueSetting(int evalTrueSetting) {
        this.evalTrueSetting = evalTrueSetting;
    }

    public void setSatisfied(boolean satisfied) {
        this.satisfied = satisfied;
    }

    public void setSatisfyingEvals(List<Set<ConditionEval>> satisfyingEvals) {
        this.satisfyingEvals = satisfyingEvals;
    }

    public void setType(Type type) {
        this.type = type;
    }

    @JsonIgnore
    public int getNumTrueEvals() {
        return this.numTrueEvals;
    }

    public void setNumTrueEvals(int numTrueEvals) {
        this.numTrueEvals = numTrueEvals;
    }

    @JsonIgnore
    public long getTrueEvalsStartTime() {
        return this.trueEvalsStartTime;
    }

    public void setTrueEvalsStartTime(long trueEvalsStartTime) {
        this.trueEvalsStartTime = trueEvalsStartTime;
    }

    @JsonIgnore
    public int getNumEvals() {
        return this.numEvals;
    }

    public void setNumEvals(int numEvals) {
        this.numEvals = numEvals;
    }

    public Type getType() {
        return this.type;
    }

    public int getEvalTrueSetting() {
        return this.evalTrueSetting;
    }

    public int getEvalTotalSetting() {
        return this.evalTotalSetting;
    }

    public long getEvalTimeSetting() {
        return this.evalTimeSetting;
    }

    @JsonIgnore
    public Map<Integer, ConditionEval> getCurrentEvals() {
        return this.currentEvals;
    }

    @JsonIgnore
    public boolean isSatisfied() {
        return this.satisfied;
    }

    @JsonIgnore
    public List<Set<ConditionEval>> getSatisfyingEvals() {
        return new ArrayList<Set<ConditionEval>>(this.satisfyingEvals);
    }

    public void addSatisfyingEvals(Set<ConditionEval> satisfyingEvals) {
        this.satisfyingEvals.add(satisfyingEvals);
    }

    public void addSatisfyingEvals(ConditionEval ... satisfyingEvals) {
        this.satisfyingEvals.add(new HashSet<ConditionEval>(Arrays.asList(satisfyingEvals)));
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
        this.updateId();
    }

    public void perform(Match match, Set<ConditionEval> conditionEvalSet) {
        if (null == match) {
            throw new IllegalArgumentException("Match can not be null");
        }
        if (null == conditionEvalSet || this.isEmpty(conditionEvalSet)) {
            throw new IllegalArgumentException("ConditionEval Set can not be null or empty");
        }
        conditionEvalSet.stream().forEach(conditionEval -> this.currentEvals.put(conditionEval.getConditionSetIndex(), (ConditionEval)conditionEval));
        int conditionSetSize = conditionEvalSet.iterator().next().getConditionSetSize();
        boolean trueEval = false;
        block0 : switch (match) {
            case ALL: {
                if (this.currentEvals.size() < conditionSetSize) {
                    return;
                }
                trueEval = true;
                for (ConditionEval ce : this.currentEvals.values()) {
                    if (ce.isMatch()) continue;
                    trueEval = false;
                    break block0;
                }
                break;
            }
            case ANY: {
                trueEval = false;
                for (ConditionEval ce : this.currentEvals.values()) {
                    if (!ce.isMatch()) continue;
                    trueEval = true;
                    break block0;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected Match type: " + match.name());
            }
        }
        long now = System.currentTimeMillis();
        if (this.type == Type.RELAXED_TIME && this.trueEvalsStartTime != 0L && now - this.trueEvalsStartTime > this.evalTimeSetting) {
            this.reset();
        }
        ++this.numEvals;
        if (trueEval) {
            ++this.numTrueEvals;
            this.addSatisfyingEvals(new HashSet<ConditionEval>(this.currentEvals.values()));
            switch (this.type) {
                case STRICT: 
                case RELAXED_COUNT: {
                    if (this.numTrueEvals != this.evalTrueSetting) break;
                    this.satisfied = true;
                    break;
                }
                case RELAXED_TIME: {
                    if (this.trueEvalsStartTime == 0L) {
                        this.trueEvalsStartTime = now;
                    }
                    if (this.numTrueEvals != this.evalTrueSetting || now - this.trueEvalsStartTime >= this.evalTimeSetting) break;
                    this.satisfied = true;
                    break;
                }
                case STRICT_TIME: 
                case STRICT_TIMEOUT: {
                    if (this.trueEvalsStartTime == 0L) {
                        this.trueEvalsStartTime = now;
                        break;
                    }
                    if (now - this.trueEvalsStartTime < this.evalTimeSetting) break;
                    this.satisfied = true;
                }
            }
        } else {
            switch (this.type) {
                case STRICT: 
                case STRICT_TIME: 
                case STRICT_TIMEOUT: {
                    this.reset();
                    break;
                }
                case RELAXED_COUNT: {
                    int numNeeded = this.evalTrueSetting - this.numTrueEvals;
                    int chancesLeft = this.evalTotalSetting - this.numEvals;
                    if (numNeeded <= chancesLeft) break;
                    this.reset();
                    break;
                }
            }
        }
    }

    public void reset() {
        this.numTrueEvals = 0;
        this.numEvals = 0;
        this.trueEvalsStartTime = 0L;
        this.satisfied = false;
        this.satisfyingEvals.clear();
    }

    public String log() {
        StringBuilder sb = new StringBuilder("[" + this.triggerId + ", numTrueEvals=" + this.numTrueEvals + ", numEvals=" + this.numEvals + ", trueEvalsStartTime=" + this.trueEvalsStartTime + ", satisfied=" + this.satisfied);
        if (this.satisfied) {
            for (Set<ConditionEval> ces : this.satisfyingEvals) {
                sb.append("\n\t[");
                String space = "";
                for (ConditionEval ce : ces) {
                    sb.append(space);
                    sb.append("[");
                    sb.append(ce.getLog());
                    sb.append("]");
                    space = " ";
                }
                sb.append("]");
            }
        }
        return sb.toString();
    }

    public String getDampeningId() {
        return this.dampeningId;
    }

    private void updateId() {
        StringBuilder sb = new StringBuilder(this.tenantId);
        sb.append("-").append(this.triggerId);
        sb.append("-").append(this.triggerMode.name());
        this.dampeningId = sb.toString();
    }

    private boolean isEmpty(Collection<?> c) {
        return null == c || c.isEmpty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dampeningId == null ? 0 : this.dampeningId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dampening other = (Dampening)obj;
        return !(this.dampeningId == null ? other.dampeningId != null : !this.dampeningId.equals(other.dampeningId));
    }

    public String toString() {
        return "Dampening [satisfied=" + this.satisfied + ", triggerId=" + this.triggerId + ", triggerMode=" + (Object)((Object)this.triggerMode) + ", type=" + (Object)((Object)this.type) + ", evalTrueSetting=" + this.evalTrueSetting + ", evalTotalSetting=" + this.evalTotalSetting + ", evalTimeSetting=" + this.evalTimeSetting + ", numTrueEvals=" + this.numTrueEvals + ", numEvals=" + this.numEvals + ", trueEvalsStartTime=" + this.trueEvalsStartTime + "]";
    }

    public static enum Type {
        STRICT,
        RELAXED_COUNT,
        RELAXED_TIME,
        STRICT_TIME,
        STRICT_TIMEOUT;

    }
}

