/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.trigger;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hawkular.alerts.api.model.action.TimeConstraint;

@ApiModel(description="Link an <<ActionDefinition>> with a <<Trigger>>. + \n + \nIt can add optional constraints that determine when an action will be executed: + \n + \n- A set of Alert.Status (represented by its string value). + \nThe action will be executed if the linked Alert is set to one of the defined states. + \nUnlike Alerts, Events don't have lifecycle, TriggerActions on Events are all executed at Event creation time. + \n + \n- A <<TimeConstraint>> object that defines a time interval in absolute or relative way. + \nThe action will be executed if the action creation time is satisfied by the time interval.")
public class TriggerAction
implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value="Tenant id owner of this trigger.", position=0, required=false, allowableValues="Tenant is overwritten from Hawkular-Tenant HTTP header parameter request")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String tenantId;
    @ApiModelProperty(value="Action plugin identifier.", position=1, required=true, allowableValues="Only plugins deployed on the system are valid.")
    @JsonInclude
    private String actionPlugin;
    @ApiModelProperty(value="Action definition identifier.", position=2, required=true, allowableValues="Only existing action definitinons on the system are valid.")
    @JsonInclude
    private String actionId;
    @ApiModelProperty(value="A list of Alert.Status where this action is linked.", position=3, required=false, allowableValues="OPEN, ACKNOWLEDGED, RESOLVED")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Set<String> states;
    @ApiModelProperty(value="A list of TimeConstraint where this action is linked.", position=4, required=false)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private TimeConstraint calendar;

    public TriggerAction() {
        this(null, null, null);
    }

    public TriggerAction(String actionPlugin, String actionId) {
        this(null, actionPlugin, actionId);
    }

    public TriggerAction(String tenantId, String actionPlugin, String actionId) {
        this(tenantId, actionPlugin, actionId, new HashSet<String>(), null);
    }

    public TriggerAction(String tenantId, String actionPlugin, String actionId, Set<String> states) {
        this(tenantId, actionPlugin, actionId, new HashSet<String>(states), null);
    }

    public TriggerAction(String tenantId, String actionPlugin, String actionId, TimeConstraint calendar) {
        this(tenantId, actionPlugin, actionId, new HashSet<String>(), calendar);
    }

    public TriggerAction(String tenantId, String actionPlugin, String actionId, Set<String> states, TimeConstraint calendar) {
        this.tenantId = tenantId;
        this.actionPlugin = actionPlugin;
        this.actionId = actionId;
        this.states = states;
        this.calendar = calendar;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getActionPlugin() {
        return this.actionPlugin;
    }

    public void setActionPlugin(String actionPlugin) {
        this.actionPlugin = actionPlugin;
    }

    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public Set<String> getStates() {
        if (this.states == null) {
            this.states = new HashSet<String>();
        }
        return this.states;
    }

    public void setStates(Set<String> states) {
        this.states = states;
    }

    public void addState(String state) {
        this.getStates().add(state);
    }

    public TimeConstraint getCalendar() {
        return this.calendar;
    }

    public void setCalendar(TimeConstraint calendar) {
        this.calendar = calendar;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TriggerAction that = (TriggerAction)o;
        if (this.tenantId != null ? !this.tenantId.equals(that.tenantId) : that.tenantId != null) {
            return false;
        }
        if (this.actionPlugin != null ? !this.actionPlugin.equals(that.actionPlugin) : that.actionPlugin != null) {
            return false;
        }
        if (this.actionId != null ? !this.actionId.equals(that.actionId) : that.actionId != null) {
            return false;
        }
        if (this.states != null ? !this.states.equals(that.states) : that.states != null) {
            return false;
        }
        return this.calendar != null ? this.calendar.equals(that.calendar) : that.calendar == null;
    }

    public int hashCode() {
        int result = this.tenantId != null ? this.tenantId.hashCode() : 0;
        result = 31 * result + (this.actionPlugin != null ? this.actionPlugin.hashCode() : 0);
        result = 31 * result + (this.actionId != null ? this.actionId.hashCode() : 0);
        result = 31 * result + (this.states != null ? this.states.hashCode() : 0);
        result = 31 * result + (this.calendar != null ? this.calendar.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TriggerAction[tenantId='" + this.tenantId + '\'' + ", actionPlugin='" + this.actionPlugin + '\'' + ", actionId='" + this.actionId + '\'' + ", states=" + this.states + ", calendar='" + this.calendar + '\'' + ']';
    }
}

