/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.services;

import java.util.Set;
import org.hawkular.alerts.api.model.action.ActionDefinition;
import org.hawkular.alerts.api.model.dampening.Dampening;
import org.hawkular.alerts.api.model.trigger.Trigger;

public class DefinitionsEvent {
    private Type type;
    private String targetTenantId;
    private String targetId;
    private Set<String> dataIds;
    private String actionPlugin;
    private ActionDefinition actionDefinition;

    public DefinitionsEvent(Type type, ActionDefinition actionDefinition) {
        this(type, actionDefinition.getTenantId(), actionDefinition.getActionId(), null, actionDefinition.getActionPlugin(), actionDefinition);
    }

    public DefinitionsEvent(Type type, String targetTenantId, String targetActionPlugin, String targetActionId) {
        this(type, targetTenantId, targetActionId, null, targetActionPlugin, null);
    }

    public DefinitionsEvent(Type type, Dampening dampening) {
        this(type, dampening.getTenantId(), dampening.getDampeningId(), null, null, null);
    }

    public DefinitionsEvent(Type type, Trigger trigger) {
        this(type, trigger.getTenantId(), trigger.getId(), null, null, null);
    }

    public DefinitionsEvent(Type type, String targetTenantId, String targetId) {
        this(type, targetTenantId, targetId, null, null, null);
    }

    public DefinitionsEvent(Type type, String targetTenantId, String targetId, Set<String> dataIds) {
        this(type, targetTenantId, targetId, dataIds, null, null);
    }

    public DefinitionsEvent(Type type, String targetTenantId, String targetId, Set<String> dataIds, String actionPlugin, ActionDefinition actionDefinition) {
        this.type = type;
        this.targetTenantId = targetTenantId;
        this.targetId = targetId;
        this.dataIds = dataIds;
        this.actionPlugin = actionPlugin;
        this.actionDefinition = actionDefinition;
    }

    public Type getType() {
        return this.type;
    }

    public String getTargetTenantId() {
        return this.targetTenantId;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public Set<String> getDataIds() {
        return this.dataIds;
    }

    public String getActionPlugin() {
        return this.actionPlugin;
    }

    public void setActionPlugin(String actionPlugin) {
        this.actionPlugin = actionPlugin;
    }

    public ActionDefinition getActionDefinition() {
        return this.actionDefinition;
    }

    public void setActionDefinition(ActionDefinition actionDefinition) {
        this.actionDefinition = actionDefinition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefinitionsEvent that = (DefinitionsEvent)o;
        if (this.type != that.type) {
            return false;
        }
        if (this.targetTenantId != null ? !this.targetTenantId.equals(that.targetTenantId) : that.targetTenantId != null) {
            return false;
        }
        if (this.targetId != null ? !this.targetId.equals(that.targetId) : that.targetId != null) {
            return false;
        }
        if (this.dataIds != null ? !this.dataIds.equals(that.dataIds) : that.dataIds != null) {
            return false;
        }
        if (this.actionPlugin != null ? !this.actionPlugin.equals(that.actionPlugin) : that.actionPlugin != null) {
            return false;
        }
        return this.actionDefinition != null ? this.actionDefinition.equals(that.actionDefinition) : that.actionDefinition == null;
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.targetTenantId != null ? this.targetTenantId.hashCode() : 0);
        result = 31 * result + (this.targetId != null ? this.targetId.hashCode() : 0);
        result = 31 * result + (this.dataIds != null ? this.dataIds.hashCode() : 0);
        result = 31 * result + (this.actionPlugin != null ? this.actionPlugin.hashCode() : 0);
        result = 31 * result + (this.actionDefinition != null ? this.actionDefinition.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DefinitionsEvent{type=" + (Object)((Object)this.type) + ", targetTenantId='" + this.targetTenantId + '\'' + ", targetId='" + this.targetId + '\'' + ", dataIds=" + this.dataIds + ", actionPlugin='" + this.actionPlugin + '\'' + ", actionDefinition=" + this.actionDefinition + '}';
    }

    public static enum Type {
        ACTION_DEFINITION_CREATE,
        ACTION_DEFINITION_REMOVE,
        ACTION_DEFINITION_UPDATE,
        DAMPENING_CHANGE,
        TRIGGER_CONDITION_CHANGE,
        TRIGGER_CREATE,
        TRIGGER_REMOVE,
        TRIGGER_UPDATE;

    }
}

