/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.event;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.hawkular.alerts.api.model.condition.ConditionEval;
import org.hawkular.alerts.api.model.dampening.Dampening;
import org.hawkular.alerts.api.model.event.Alert;
import org.hawkular.alerts.api.model.event.EventCategory;
import org.hawkular.alerts.api.model.event.EventType;
import org.hawkular.alerts.api.model.event.Thin;
import org.hawkular.alerts.api.model.trigger.Trigger;

@ApiModel(description="An Alert is an Event. + \n + \nFor the most part an Event can be thought of as an Alert without life-cycle. + \n + \nAlerts are always generated by a Trigger. + \n + \nEvents may be generated by a Trigger or may be created directly via the API. + \n")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="eventType", defaultImpl=Event.class)
@JsonSubTypes(value={@JsonSubTypes.Type(name="EVENT", value=Event.class), @JsonSubTypes.Type(name="ALERT", value=Alert.class)})
public class Event
implements Comparable<Event>,
Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value="Indicate if this object is an EVENT or an ALERT. This is a read-only field controlled by the system for serialization purposes.", position=0, allowableValues="EVENT, ALERT")
    @JsonInclude
    protected String eventType;
    @ApiModelProperty(value="Tenant id owner of this event.", position=1, allowableValues="Tenant is overwritten from Hawkular-Tenant HTTP header parameter request")
    @JsonInclude
    protected String tenantId;
    @ApiModelProperty(value="Unique identifier for this event.", position=2, required=true)
    @JsonInclude
    protected String id;
    @ApiModelProperty(value="Creation time for this event.", position=3, required=true, allowableValues="Timestamp in milliseconds.")
    @JsonInclude
    protected long ctime;
    @ApiModelProperty(value="Optional dataSource for Event. Used for <<Trigger>> in <<EventCondition>> to evaluate events with triplet [tenantId, source, dataId] as unique identifier.", position=4, allowableValues="Timestamp in milliseconds.")
    @JsonInclude
    String dataSource;
    @ApiModelProperty(value="Data identifier used for Events condition evaluation. Events must supply a valid dataId to be considered for <<EventCondition>> evaluation. + \nDataIds in an events context should incorporate the source of the event (for uniqueness). + \nEvents generated from a <<Trigger>> will have dataId set to the triggerId, therefore allowing chaining with other <<EventCondition>>. ", position=5, required=true)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String dataId;
    @ApiModelProperty(value="Category of Event. Suitable for display. + \nAlerts will use ALERT category. + \nEvents generated from <<Trigger>> will use Trigger.eventCategory or TRIGGER category as default.", position=6, required=true, allowableValues="Any category defined by the user.", example="ALERT or TRIGGER")
    @JsonInclude
    private String category;
    @ApiModelProperty(value="Description of the event. Suitable for display. + \nEvents generated from <<Trigger>> will use Trigger.eventText or Trigger.description/Trigger.name as default.", position=7, required=true, allowableValues="Any description defined by the user.")
    @JsonInclude
    private String text;
    @ApiModelProperty(value="Properties defined by the user for this event. + \n Events generated from <<Trigger>> will use Trigger.context. + \nContext cannot be used as part of Event conditions expressions or criteria in finder methods.", position=8)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, String> context;
    @ApiModelProperty(value="Tags defined by the user for this event. + \n Events generated from <<Trigger>> will use Trigger.tags. + \nTags can be used as part of Event conditions expressions and criteria in finder methods. + \nTag value cannot be null.", position=9)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected Map<String, String> tags;
    @ApiModelProperty(value="Trigger that created the event. + \n Null for API-generated Events.", position=10)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Trigger trigger;
    @ApiModelProperty(value="Dampening defined when the event was created. + \n Null for API-generated Events.", position=11)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Thin
    private Dampening dampening;
    @ApiModelProperty(value="The Eval Sets that fired the trigger. + \n Null for API-generated Events.", position=12)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Thin
    private List<Set<ConditionEval>> evalSets;

    public Event() {
        this(null, (String)null, null, null);
    }

    public Event(String tenantId, String id, String category, String text) {
        this(tenantId, id, System.currentTimeMillis(), null, null, category, text, null, null);
    }

    public Event(String tenantId, String id, String dataId, String category, String text) {
        this(tenantId, id, System.currentTimeMillis(), null, dataId, category, text, null, null);
    }

    public Event(String tenantId, String id, String dataSource, String dataId, String category, String text) {
        this(tenantId, id, System.currentTimeMillis(), dataSource, dataId, category, text, null, null);
    }

    public Event(String tenantId, String id, String category, String text, Map<String, String> context) {
        this(tenantId, id, System.currentTimeMillis(), null, null, category, text, context, null);
    }

    public Event(String tenantId, String id, String dataId, String category, String text, Map<String, String> context) {
        this(tenantId, id, System.currentTimeMillis(), null, dataId, category, text, context, null);
    }

    public Event(String tenantId, String id, String dataSource, String dataId, String category, String text, Map<String, String> context) {
        this(tenantId, id, System.currentTimeMillis(), dataSource, dataId, category, text, context, null);
    }

    public Event(String tenantId, String id, long ctime, String dataId, String category, String text) {
        this(tenantId, id, ctime, null, dataId, category, text, null, null);
    }

    public Event(String tenantId, String id, long ctime, String dataSource, String dataId, String category, String text) {
        this(tenantId, id, ctime, dataSource, dataId, category, text, null, null);
    }

    public Event(String tenantId, String id, long ctime, String category, String text, Map<String, String> context) {
        this(tenantId, id, ctime, null, null, category, text, context, null);
    }

    public Event(String tenantId, String id, long ctime, String dataSource, String dataId, String category, String text, Map<String, String> context) {
        this(tenantId, id, ctime, dataSource, dataId, category, text, context, null);
    }

    public Event(String tenantId, String id, long ctime, String dataId, String category, String text, Map<String, String> context, Map<String, String> tags) {
        this(tenantId, id, ctime, null, dataId, category, text, context, tags);
    }

    public Event(String tenantId, String id, long ctime, String dataSource, String dataId, String category, String text, Map<String, String> context, Map<String, String> tags) {
        this.tenantId = tenantId;
        this.id = id;
        this.setCtime(ctime);
        this.setDataSource(dataSource);
        this.dataId = dataId;
        this.category = category;
        this.text = text;
        this.context = context;
        this.tags = tags;
        this.eventType = EventType.EVENT.name();
    }

    public Event(Alert alert) {
        this(alert.getTenantId(), alert.getTrigger(), alert.getDampening(), alert.getEvalSets());
        this.eventType = alert.getEventType();
    }

    public Event(String tenantId, Trigger trigger, Dampening dampening, List<Set<ConditionEval>> evalSets) {
        this.tenantId = tenantId;
        this.trigger = trigger;
        this.dampening = dampening;
        this.evalSets = evalSets;
        this.ctime = System.currentTimeMillis();
        this.id = trigger.getId() + "-" + this.ctime + "-" + UUID.randomUUID();
        this.dataSource = trigger.getSource();
        this.dataId = trigger.getId();
        this.context = trigger.getContext();
        if (!Event.isEmpty(trigger.getEventCategory())) {
            this.category = trigger.getEventCategory();
        } else {
            String string = this.category = EventType.ALERT == trigger.getEventType() ? EventCategory.ALERT.name() : EventCategory.TRIGGER.name();
        }
        this.text = !Event.isEmpty(trigger.getEventText()) ? trigger.getEventText() : (Event.isEmpty(trigger.getDescription()) ? trigger.getName() : trigger.getDescription());
        this.tags = trigger.getTags();
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public long getCtime() {
        return this.ctime;
    }

    public void setCtime(long ctime) {
        this.ctime = ctime <= 0L ? System.currentTimeMillis() : ctime;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = Event.isEmpty(dataSource) ? "_none_" : dataSource;
    }

    public String getDataId() {
        return this.dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Map<String, String> getTags() {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public void addTag(String name, String value) {
        if (null == name || null == value) {
            throw new IllegalArgumentException("Tag must have non-null name and value");
        }
        this.getTags().put(name, value);
    }

    public void removeTag(String name) {
        if (null == name) {
            throw new IllegalArgumentException("Tag must have non-null name");
        }
        this.getTags().remove(name);
    }

    public Map<String, String> getContext() {
        if (null == this.context) {
            this.context = new HashMap<String, String>();
        }
        return this.context;
    }

    public void setContext(Map<String, String> context) {
        this.context = context;
    }

    public void addContext(String name, String value) {
        if (null == name || null == value) {
            throw new IllegalArgumentException("Propety must have non-null name and value");
        }
        this.getContext().put(name, value);
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public void setTrigger(Trigger trigger) {
        this.trigger = trigger;
    }

    public Dampening getDampening() {
        return this.dampening;
    }

    public void setDampening(Dampening dampening) {
        this.dampening = dampening;
    }

    public List<Set<ConditionEval>> getEvalSets() {
        return this.evalSets;
    }

    public void setEvalSets(List<Set<ConditionEval>> evalSets) {
        this.evalSets = evalSets;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.tenantId == null ? 0 : this.tenantId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Event other = (Event)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.tenantId == null ? other.tenantId != null : !this.tenantId.equals(other.tenantId));
    }

    public String toString() {
        return "Event [tenantId=" + this.tenantId + ", id=" + this.id + ", ctime=" + this.ctime + ", category=" + this.category + ", dataId=" + this.dataId + ", dataSource=" + this.dataSource + ", text=" + this.text + ", context=" + this.context + ", tags=" + this.tags + ", trigger=" + this.trigger + "]";
    }

    @Override
    public int compareTo(Event o) {
        if (this.dataId == null) {
            return this.id.compareTo(o.id);
        }
        int c = this.dataId.compareTo(o.dataId);
        if (0 != c) {
            return c;
        }
        c = this.tenantId.compareTo(o.tenantId);
        if (0 != c) {
            return c;
        }
        c = this.dataSource.compareTo(o.dataSource);
        if (0 != c) {
            return c;
        }
        c = Long.compare(this.ctime, o.ctime);
        if (0 != c) {
            return c;
        }
        return this.id.compareTo(o.id);
    }

    public boolean same(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Event other = (Event)obj;
        if (this.dataId == null ? other.dataId != null : !this.dataId.equals(other.dataId)) {
            return false;
        }
        if (this.dataSource == null ? other.dataSource != null : !this.dataSource.equals(other.dataSource)) {
            return false;
        }
        return !(this.tenantId == null ? other.tenantId != null : !this.tenantId.equals(other.tenantId));
    }

    private static boolean isEmpty(String s) {
        return null == s || s.trim().isEmpty();
    }
}

