/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.services;

import java.util.Arrays;
import java.util.Collection;

public class EventsCriteria {
    Long startTime = null;
    Long endTime = null;
    String eventId = null;
    Collection<String> eventIds = null;
    String category = null;
    Collection<String> categories = null;
    String triggerId = null;
    Collection<String> triggerIds = null;
    String tagQuery = null;
    boolean thin = false;
    Integer criteriaNoQuerySize = null;

    public EventsCriteria() {
    }

    public EventsCriteria(Long startTime, Long endTime, String eventIds, String triggerIds, String categories, String tagQuery, Boolean thin) {
        this.setStartTime(startTime);
        this.setEndTime(endTime);
        if (!EventsCriteria.isEmpty(eventIds)) {
            this.setEventIds(Arrays.asList(eventIds.split(",")));
        }
        if (!EventsCriteria.isEmpty(triggerIds)) {
            this.setTriggerIds(Arrays.asList(triggerIds.split(",")));
        }
        if (!EventsCriteria.isEmpty(categories)) {
            this.setCategories(Arrays.asList(categories.split(",")));
        }
        this.setTagQuery(tagQuery);
        if (null != thin) {
            this.setThin(thin);
        }
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public Collection<String> getEventIds() {
        return this.eventIds;
    }

    public void setEventIds(Collection<String> eventIds) {
        this.eventIds = eventIds;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public Collection<String> getCategories() {
        return this.categories;
    }

    public void setCategories(Collection<String> categories) {
        this.categories = categories;
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
    }

    public Collection<String> getTriggerIds() {
        return this.triggerIds;
    }

    public void setTriggerIds(Collection<String> triggerIds) {
        this.triggerIds = triggerIds;
    }

    public String getTagQuery() {
        return this.tagQuery;
    }

    public void setTagQuery(String tagQuery) {
        this.tagQuery = tagQuery;
    }

    public boolean isThin() {
        return this.thin;
    }

    public void setThin(boolean thin) {
        this.thin = thin;
    }

    public Integer getCriteriaNoQuerySize() {
        return this.criteriaNoQuerySize;
    }

    public void setCriteriaNoQuerySize(Integer criteriaNoQuerySize) {
        this.criteriaNoQuerySize = criteriaNoQuerySize;
    }

    public boolean hasEventIdCriteria() {
        return null != this.eventId || null != this.eventIds && !this.eventIds.isEmpty();
    }

    public boolean hasCategoryCriteria() {
        return null != this.category || null != this.categories && !this.categories.isEmpty();
    }

    public boolean hasTagQueryCriteria() {
        return !EventsCriteria.isEmpty(this.tagQuery);
    }

    public boolean hasCTimeCriteria() {
        return null != this.startTime || null != this.endTime;
    }

    public boolean hasTriggerIdCriteria() {
        return null != this.triggerId || null != this.triggerIds && !this.triggerIds.isEmpty();
    }

    public boolean hasCriteria() {
        return this.hasEventIdCriteria() || this.hasCategoryCriteria() || this.hasTagQueryCriteria() || this.hasCTimeCriteria() || this.hasTriggerIdCriteria();
    }

    public String toString() {
        return "EventsCriteria{startTime=" + this.startTime + ", endTime=" + this.endTime + ", eventId='" + this.eventId + '\'' + ", eventIds=" + this.eventIds + ", category='" + this.category + '\'' + ", categories=" + this.categories + ", triggerId='" + this.triggerId + '\'' + ", triggerIds=" + this.triggerIds + ", tagQuery='" + this.tagQuery + '\'' + ", thin=" + this.thin + ", criteriaNoQuerySize=" + this.criteriaNoQuerySize + '}';
    }

    private static boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }
}

