/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.action;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import org.hawkular.alerts.api.model.action.ActionDefinition;
import org.hawkular.alerts.api.model.event.Event;
import org.hawkular.alerts.api.model.event.Thin;

@ApiModel(description="An action represents a consequence of an event. + \n + \nAn Action object represents a particular action linked with a specific event. + \nAction objects are generated by the Alerting engine and processed by plugins. + \nAn Action object stores the eventId property and optionally may contain the full Event object. + \nAn Action may store the result of the processing by a plugin. + \n")
public class Action
extends ActionDefinition
implements Serializable {
    @ApiModelProperty(value="Event id from where this action is generated.", position=0)
    @JsonInclude
    private String eventId;
    @ApiModelProperty(value="Time when this action was generated.", position=1)
    @JsonInclude
    private long ctime;
    @ApiModelProperty(value="Attached Event from where this action is generated.", position=2)
    @Thin
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Event event;
    @ApiModelProperty(value="Result of action processing.", position=3)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String result;

    public Action() {
    }

    public Action(String tenantId, String actionPlugin, String actionId, Event event) {
        super(tenantId, actionPlugin, actionId);
        this.event = event;
        if (event != null) {
            this.eventId = event.getId();
        }
        this.ctime = System.currentTimeMillis();
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public long getCtime() {
        return this.ctime;
    }

    public void setCtime(long ctime) {
        this.ctime = ctime;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Action action = (Action)o;
        if (this.ctime != action.ctime) {
            return false;
        }
        if (this.eventId != null ? !this.eventId.equals(action.eventId) : action.eventId != null) {
            return false;
        }
        if (this.event != null ? !this.event.equals(action.event) : action.event != null) {
            return false;
        }
        return this.result != null ? this.result.equals(action.result) : action.result == null;
    }

    @Override
    public int hashCode() {
        int result1 = super.hashCode();
        result1 = 31 * result1 + (this.eventId != null ? this.eventId.hashCode() : 0);
        result1 = 31 * result1 + (int)(this.ctime ^ this.ctime >>> 32);
        result1 = 31 * result1 + (this.event != null ? this.event.hashCode() : 0);
        result1 = 31 * result1 + (this.result != null ? this.result.hashCode() : 0);
        return result1;
    }

    @Override
    public String toString() {
        return "Action[eventId='" + this.eventId + '\'' + ", ctime=" + this.ctime + ", event=" + this.event + ", result='" + this.result + '\'' + ']';
    }
}

