/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.condition;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.ConditionEval;
import org.hawkular.alerts.api.model.condition.ExternalCondition;
import org.hawkular.alerts.api.model.data.Data;
import org.hawkular.alerts.api.model.event.Event;

@ApiModel(description="An evaluation state for an external condition. + \nNote that external conditions may report a Data value or an Event.")
public class ExternalConditionEval
extends ConditionEval {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value="External condition linked with this state.", position=0)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private ExternalCondition condition;
    @ApiModelProperty(value="String value used for dataId.", position=1)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String value;
    @ApiModelProperty(value="Event value used for dataId.", position=2)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Event event;

    public ExternalConditionEval() {
        super(Condition.Type.EXTERNAL, false, 0L, null);
        this.condition = null;
        this.value = null;
        this.event = null;
    }

    public ExternalConditionEval(ExternalCondition condition, Event event) {
        super(Condition.Type.EXTERNAL, condition.match(event.getText()), event.getCtime(), event.getContext());
        this.condition = condition;
        this.event = event;
    }

    public ExternalConditionEval(ExternalCondition condition, Data data) {
        super(Condition.Type.EXTERNAL, condition.match(data.getValue()), data.getTimestamp(), data.getContext());
        this.condition = condition;
        this.value = data.getValue();
    }

    public ExternalCondition getCondition() {
        return this.condition;
    }

    public void setCondition(ExternalCondition condition) {
        this.condition = condition;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    @Override
    public String getTenantId() {
        return this.condition.getTenantId();
    }

    @Override
    public String getTriggerId() {
        return this.condition.getTriggerId();
    }

    @Override
    public int getConditionSetSize() {
        return this.condition.getConditionSetSize();
    }

    @Override
    public int getConditionSetIndex() {
        return this.condition.getConditionSetIndex();
    }

    @Override
    public String getLog() {
        if (this.value != null) {
            return this.condition.getLog(this.value) + ", evalTimestamp=" + this.evalTimestamp + ", dataTimestamp=" + this.dataTimestamp;
        }
        return this.condition.getLog(this.event) + ", evalTimestamp=" + this.evalTimestamp + ", dataTimestamp=" + this.dataTimestamp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExternalConditionEval that = (ExternalConditionEval)o;
        if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        return this.event != null ? this.event.equals(that.event) : that.event == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.event != null ? this.event.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ExternalConditionEval{condition=" + this.condition + ", value='" + this.value + '\'' + ", event=" + this.event + '}';
    }
}

