/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.condition;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.ConditionEval;
import org.hawkular.alerts.api.model.condition.NelsonCondition;
import org.hawkular.alerts.api.model.data.Data;

@ApiModel(description="An evaluation state for nelson condition.")
public class NelsonConditionEval
extends ConditionEval {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value="Nelson condition linked with this state.", position=0)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private NelsonCondition condition;
    @ApiModelProperty(value="Mean applied to NelsonRules.", position=1)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Double mean;
    @ApiModelProperty(value="Standard Deviation applied to NelsonRules.", position=2)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Double standardDeviation;
    @ApiModelProperty(value="Data used to determine violations.", position=3)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<Data> violationsData;
    @ApiModelProperty(value="NelsonRule violations for the data.", position=4)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<NelsonCondition.NelsonRule> violations;

    public NelsonConditionEval() {
        super(Condition.Type.NELSON, false, 0L, null);
    }

    public NelsonConditionEval(NelsonCondition condition, Data data, List<NelsonCondition.NelsonRule> violations, Double mean, Double standardDeviation, List<Data> violationsData) {
        super(Condition.Type.NELSON, condition.match(violations), data.getTimestamp(), data.getContext());
        this.condition = condition;
        this.mean = mean;
        this.standardDeviation = standardDeviation;
        this.violations = violations;
        this.violationsData = violationsData;
    }

    public NelsonCondition getCondition() {
        return this.condition;
    }

    public void setCondition(NelsonCondition condition) {
        this.condition = condition;
    }

    public Double getMean() {
        return this.mean;
    }

    public void setMean(Double mean) {
        this.mean = mean;
    }

    public Double getStandardDeviation() {
        return this.standardDeviation;
    }

    public void setStandardDeviation(Double standardDeviation) {
        this.standardDeviation = standardDeviation;
    }

    public List<Data> getViolationsData() {
        return this.violationsData;
    }

    public void setViolationsData(List<Data> violationsData) {
        this.violationsData = violationsData;
    }

    public List<NelsonCondition.NelsonRule> getViolations() {
        return this.violations;
    }

    public void setViolations(List<NelsonCondition.NelsonRule> violations) {
        this.violations = violations;
    }

    @Override
    public String getTenantId() {
        return this.condition.getTenantId();
    }

    @Override
    public String getTriggerId() {
        return this.condition.getTriggerId();
    }

    @Override
    public int getConditionSetSize() {
        return this.condition.getConditionSetSize();
    }

    @Override
    public int getConditionSetIndex() {
        return this.condition.getConditionSetIndex();
    }

    @Override
    public String getLog() {
        return this.condition.getLog(this.violations, this.mean, this.standardDeviation, this.violationsData);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.condition == null ? 0 : this.condition.hashCode());
        result = 31 * result + (this.violations == null ? 0 : this.violations.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NelsonConditionEval other = (NelsonConditionEval)obj;
        if (this.condition == null ? other.condition != null : !this.condition.equals(other.condition)) {
            return false;
        }
        return !(this.violations == null ? other.violations != null : !this.violations.equals(other.violations));
    }

    public String toString() {
        return "NelsonConditionEval [condition=" + this.condition + ", mean=" + this.mean + ", standardDeviation=" + this.standardDeviation + ", violations=" + this.violations + "]";
    }
}

