/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.paging;

import java.util.Comparator;
import org.hawkular.alerts.api.model.action.Action;
import org.hawkular.alerts.api.model.paging.Order;

public class ActionComparator
implements Comparator<Action> {
    private Field field;
    private Order.Direction direction;

    public ActionComparator() {
        this(Field.ALERT_ID, Order.Direction.ASCENDING);
    }

    public ActionComparator(Field field, Order.Direction direction) {
        this.field = field;
        this.direction = direction;
    }

    @Override
    public int compare(Action o1, Action o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null && o2 != null) {
            return 1;
        }
        if (o1 != null && o2 == null) {
            return -1;
        }
        int iOrder = this.direction == Order.Direction.ASCENDING ? 1 : -1;
        switch (this.field) {
            case ALERT_ID: {
                if (o1.getEvent() == null && o2.getEvent() == null) {
                    return 0;
                }
                if (o1.getEvent() == null && o2.getEvent() != null) {
                    return 1;
                }
                if (o1.getEvent() != null && o2.getEvent() == null) {
                    return -1;
                }
                if (o1.getEvent().getId() == null && o2.getEvent().getId() == null) {
                    return 0;
                }
                if (o1.getEvent().getId() == null && o2.getEvent().getId() != null) {
                    return 1;
                }
                if (o1.getEvent().getId() != null && o2.getEvent().getId() == null) {
                    return -1;
                }
                return o1.getEvent().getId().compareTo(o2.getEvent().getId()) * iOrder;
            }
            case ACTION_PLUGIN: {
                if (o1.getActionPlugin() == null && o2.getActionPlugin() == null) {
                    return 0;
                }
                if (o1.getActionPlugin() == null && o2.getActionPlugin() != null) {
                    return 1;
                }
                if (o1.getActionPlugin() != null && o2.getActionPlugin() == null) {
                    return -1;
                }
                return o1.getActionPlugin().compareTo(o2.getActionPlugin()) * iOrder;
            }
            case CTIME: {
                return (int)((o1.getCtime() - o2.getCtime()) * (long)iOrder);
            }
            case ACTION_ID: {
                if (o1.getActionId() == null && o2.getActionId() == null) {
                    return 0;
                }
                if (o1.getActionId() == null && o2.getActionId() != null) {
                    return 1;
                }
                if (o1.getActionId() != null && o2.getActionId() == null) {
                    return -1;
                }
                return o1.getActionId().compareTo(o2.getActionId()) * iOrder;
            }
            case RESULT: {
                if (o1.getResult() == null && o2.getResult() == null) {
                    return 0;
                }
                if (o1.getResult() == null && o2.getResult() != null) {
                    return 1;
                }
                if (o1.getResult() != null && o2.getResult() == null) {
                    return -1;
                }
                return o1.getResult().compareTo(o2.getResult()) * iOrder;
            }
        }
        return 0;
    }

    public static enum Field {
        ACTION_PLUGIN("actionPlugin"),
        ACTION_ID("actionId"),
        ALERT_ID("alertId"),
        CTIME("ctime"),
        RESULT("result");

        private String text;

        private Field(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public static Field getField(String text) {
            if (text == null || text.isEmpty()) {
                return ALERT_ID;
            }
            for (Field f : Field.values()) {
                if (f.getText().compareToIgnoreCase(text) != 0) continue;
                return f;
            }
            return ALERT_ID;
        }
    }
}

