/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.paging;

import java.util.Comparator;
import org.hawkular.alerts.api.model.paging.Order;
import org.hawkular.alerts.api.model.trigger.Trigger;

public class TriggerComparator
implements Comparator<Trigger> {
    private Field field;
    private String contextKey;
    private Order.Direction direction;

    public TriggerComparator() {
        this(Field.NAME.getName(), Order.Direction.ASCENDING);
    }

    public TriggerComparator(String fieldName, Order.Direction direction) {
        this.field = Field.getField(fieldName);
        if (Field.CONTEXT == this.field) {
            this.contextKey = Field.getContextKey(fieldName);
        }
        this.direction = direction;
    }

    @Override
    public int compare(Trigger o1, Trigger o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null && o2 != null) {
            return 1;
        }
        if (o1 != null && o2 == null) {
            return -1;
        }
        int iOrder = this.direction == Order.Direction.ASCENDING ? 1 : -1;
        switch (this.field) {
            case ID: {
                return o1.getId().compareTo(o2.getId()) * iOrder;
            }
            case CONTEXT: {
                if (o1.getContext() == null && o2.getContext() == null) {
                    return 0;
                }
                if (o1.getContext().isEmpty() && o2.getContext().isEmpty()) {
                    return 0;
                }
                if (!o1.getContext().containsKey(this.contextKey) && !o2.getContext().containsKey(this.contextKey)) {
                    return 0;
                }
                if (!o1.getContext().containsKey(this.contextKey) && o2.getContext().containsKey(this.contextKey)) {
                    return 1;
                }
                if (!o1.getContext().containsKey(this.contextKey) && !o2.getContext().containsKey(this.contextKey)) {
                    return -1;
                }
                return o1.getContext().get(this.contextKey).compareTo(o2.getContext().get(this.contextKey)) * iOrder;
            }
            case DESCRIPTION: {
                if (o1.getDescription() == null && o2.getDescription() == null) {
                    return 0;
                }
                if (o1.getDescription() == null && o2.getDescription() != null) {
                    return 1;
                }
                if (o1.getDescription() != null && o2.getDescription() == null) {
                    return -1;
                }
                return o1.getDescription().compareTo(o2.getDescription()) * iOrder;
            }
            case ENABLED: {
                if (o1.isEnabled() == o2.isEnabled()) {
                    return 0;
                }
                return (o1.isEnabled() ? 1 : -1) * iOrder;
            }
            case NAME: {
                if (o1.getDescription() == null && o2.getName() == null) {
                    return 0;
                }
                if (o1.getName() == null && o2.getName() != null) {
                    return 1;
                }
                if (o1.getName() != null && o2.getName() == null) {
                    return -1;
                }
                return o1.getName().compareTo(o2.getName()) * iOrder;
            }
            case SEVERITY: {
                if (o1.getSeverity() == null && o2.getSeverity() == null) {
                    return 0;
                }
                if (o1.getSeverity() == null && o2.getSeverity() != null) {
                    return 1;
                }
                if (o1.getSeverity() != null && o2.getSeverity() == null) {
                    return -1;
                }
                return o1.getSeverity().compareTo(o2.getSeverity()) * iOrder;
            }
        }
        return 0;
    }

    public static enum Field {
        ID("id"),
        DESCRIPTION("description"),
        ENABLED("enabled"),
        NAME("name"),
        SEVERITY("severity"),
        CONTEXT("context");

        private String name;

        private Field(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Field getField(String name) {
            if (name == null || name.trim().isEmpty()) {
                return NAME;
            }
            for (Field f : Field.values()) {
                if (CONTEXT == f && name.toLowerCase().startsWith("context.")) {
                    return f;
                }
                if (f.getName().compareToIgnoreCase(name) != 0) continue;
                return f;
            }
            return NAME;
        }

        public static String getContextKey(String context) {
            if (context == null || context.trim().isEmpty() || !context.toLowerCase().startsWith("context.")) {
                return "";
            }
            return context.substring(8);
        }
    }
}

