/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.services;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.hawkular.alerts.api.model.Severity;
import org.hawkular.alerts.api.model.event.Alert;

public class AlertsCriteria {
    Long startTime = null;
    Long endTime = null;
    Long startResolvedTime = null;
    Long endResolvedTime = null;
    Long startAckTime = null;
    Long endAckTime = null;
    Long startStatusTime = null;
    Long endStatusTime = null;
    String alertId = null;
    Collection<String> alertIds = null;
    Alert.Status status = null;
    Collection<Alert.Status> statusSet = null;
    Severity severity = null;
    Collection<Severity> severities = null;
    String triggerId = null;
    Collection<String> triggerIds = null;
    String tagQuery = null;
    boolean thin = false;

    public AlertsCriteria() {
    }

    public AlertsCriteria(Long startTime, Long endTime, String alertIds, String triggerIds, String statuses, String severities, String tagQuery, Long startResolvedTime, Long endResolvedTime, Long startAckTime, Long endAckTime, Long startStatusTime, Long endStatusTime, Boolean thin) {
        this.setStartTime(startTime);
        this.setEndTime(endTime);
        if (!AlertsCriteria.isEmpty(alertIds)) {
            this.setAlertIds(Arrays.asList(alertIds.split(",")));
        }
        if (!AlertsCriteria.isEmpty(triggerIds)) {
            this.setTriggerIds(Arrays.asList(triggerIds.split(",")));
        }
        if (!AlertsCriteria.isEmpty(statuses)) {
            HashSet<Alert.Status> statusSet = new HashSet<Alert.Status>();
            for (String s : statuses.split(",")) {
                statusSet.add(Alert.Status.valueOf(s));
            }
            this.setStatusSet(statusSet);
        }
        if (null != severities && !severities.trim().isEmpty()) {
            HashSet<Severity> severitySet = new HashSet<Severity>();
            for (String s : severities.split(",")) {
                severitySet.add(Severity.valueOf(s));
            }
            this.setSeverities(severitySet);
        }
        this.setTagQuery(tagQuery);
        this.setStartResolvedTime(startResolvedTime);
        this.setEndResolvedTime(endResolvedTime);
        this.setStartAckTime(startAckTime);
        this.setEndAckTime(endAckTime);
        this.setStartStatusTime(startStatusTime);
        this.setEndStatusTime(endStatusTime);
        if (null != thin) {
            this.setThin(thin);
        }
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public Long getStartResolvedTime() {
        return this.startResolvedTime;
    }

    public void setStartResolvedTime(Long startResolvedTime) {
        this.startResolvedTime = startResolvedTime;
    }

    public Long getEndResolvedTime() {
        return this.endResolvedTime;
    }

    public void setEndResolvedTime(Long endResolvedTime) {
        this.endResolvedTime = endResolvedTime;
    }

    public Long getStartAckTime() {
        return this.startAckTime;
    }

    public void setStartAckTime(Long startAckTime) {
        this.startAckTime = startAckTime;
    }

    public Long getEndAckTime() {
        return this.endAckTime;
    }

    public void setEndAckTime(Long endAckTime) {
        this.endAckTime = endAckTime;
    }

    public Long getStartStatusTime() {
        return this.startStatusTime;
    }

    public void setStartStatusTime(Long startStatusTime) {
        this.startStatusTime = startStatusTime;
    }

    public Long getEndStatusTime() {
        return this.endStatusTime;
    }

    public void setEndStatusTime(Long endStatusTime) {
        this.endStatusTime = endStatusTime;
    }

    public String getAlertId() {
        return this.alertId;
    }

    public void setAlertId(String alertId) {
        this.alertId = alertId;
    }

    public Collection<String> getAlertIds() {
        return this.alertIds;
    }

    public void setAlertIds(Collection<String> alertIds) {
        this.alertIds = alertIds;
    }

    public Alert.Status getStatus() {
        return this.status;
    }

    public void setStatus(Alert.Status status) {
        this.status = status;
    }

    public Collection<Alert.Status> getStatusSet() {
        return this.statusSet;
    }

    public void setStatusSet(Collection<Alert.Status> statusSet) {
        this.statusSet = statusSet;
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
    }

    public Collection<String> getTriggerIds() {
        return this.triggerIds;
    }

    public void setTriggerIds(Collection<String> triggerIds) {
        this.triggerIds = triggerIds;
    }

    public String getTagQuery() {
        return this.tagQuery;
    }

    public void setTagQuery(String tagQuery) {
        this.tagQuery = tagQuery;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public Collection<Severity> getSeverities() {
        return this.severities;
    }

    public void setSeverities(Collection<Severity> severities) {
        this.severities = severities;
    }

    public boolean isThin() {
        return this.thin;
    }

    public void setThin(boolean thin) {
        this.thin = thin;
    }

    public boolean hasAlertIdCriteria() {
        return null != this.alertId || null != this.alertIds && !this.alertIds.isEmpty();
    }

    public boolean hasSeverityCriteria() {
        return null != this.severity || null != this.severities && !this.severities.isEmpty();
    }

    public boolean hasStatusCriteria() {
        return null != this.status || null != this.statusSet && !this.statusSet.isEmpty();
    }

    public boolean hasTagQueryCriteria() {
        return null != this.tagQuery && !AlertsCriteria.isEmpty(this.tagQuery);
    }

    public boolean hasCTimeCriteria() {
        return null != this.startTime || null != this.endTime;
    }

    public boolean hasTriggerIdCriteria() {
        return null != this.triggerId || null != this.triggerIds && !this.triggerIds.isEmpty();
    }

    public boolean hasResolvedTimeCriteria() {
        return null != this.startResolvedTime || null != this.endResolvedTime;
    }

    public boolean hasAckTimeCriteria() {
        return null != this.startAckTime || null != this.endAckTime;
    }

    public boolean hasStatusTimeCriteria() {
        return null != this.startStatusTime || null != this.endStatusTime;
    }

    public boolean hasCriteria() {
        return this.hasAlertIdCriteria() || this.hasStatusCriteria() || this.hasSeverityCriteria() || this.hasTagQueryCriteria() || this.hasCTimeCriteria() || this.hasTriggerIdCriteria() || this.hasResolvedTimeCriteria() || this.hasAckTimeCriteria() || this.hasStatusTimeCriteria();
    }

    public String toString() {
        return "AlertsCriteria{startTime=" + this.startTime + ", endTime=" + this.endTime + ", startResolvedTime=" + this.startResolvedTime + ", endResolvedTime=" + this.endResolvedTime + ", startAckTime=" + this.startAckTime + ", endAckTime=" + this.endAckTime + ", startStatusTime=" + this.startStatusTime + ", endStatusTime=" + this.endStatusTime + ", alertId='" + this.alertId + '\'' + ", alertIds=" + this.alertIds + ", status=" + (Object)((Object)this.status) + ", statusSet=" + this.statusSet + ", severity=" + (Object)((Object)this.severity) + ", severities=" + this.severities + ", triggerId='" + this.triggerId + '\'' + ", triggerIds=" + this.triggerIds + ", tagQuery='" + this.tagQuery + '\'' + ", thin=" + this.thin + '}';
    }

    private static boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }
}

