/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.hawkular.alerts.api.model.condition.Condition;

@ApiModel(description="A convenience class used in the REST API to POST a new Group Condition. + \n + \nA group-level condition uses dataId tokens for the dataIds defined in the condition.  + \nThe group members must then replace the tokens with actual dataIds. + \n + \nFor example, we may define a group ThresholdCondition like ( $SystemLoad$ > 80 ). + \nEach member must then replace $SystemLoad$ with the actual system load dataId for that member. + \n + \nThe dataIdMemberMap is a map of the dataId tokens in the group conditions to the actual dataIds + \nused for the current member triggers. + \nBecause most condition types have only one dataId the map will typically have 1 entry per condition. + \nBut because a condition could have multiple dataIds (e.g CompareCondition has dataId and data2Id), + \nit may have more entries than conditions. + \nThe inner map maps member triggerIds to the dataId to be used for that member trigger for the given token. + \nIt should have 1 entry for each member trigger. + \n + \nFor example, let's define a group trigger with two conditions: + \n + \nThresholdCondition( $SystemLoad$ > 80 ) + \nThresholdCondition( $HeapUsed$ > 70 ) + \n + \nIf the group has two current members, with triggerId's Member1 and Member2, + \nthe map would look like this: + \n + \n{ + \n\"$SystemLoad$\":{\"Member1\":\"Member1SystemLoad\", \"Member2\":\"Member2SystemLoad\"}, + \n\"$HeapUsed$\":{\"Member1\":\"Member1HeapUsed\", \"Member2\":\"Member2HeapUsed\"} + \n} + \n + \nSo, in the example the actual $SystemLoad$ dataIds would be Member1SystemLoad and Member2SystemLoad. + \nWith this Map we can now add the group-level conditions and also the two member-level conditions + \nto each member + \n + \nA NOTE ABOUT EXTERNAL CONDITIONS. <code>ExternalCondition.expression</code> will automatically have the + \nsame token replacement performed. So, all occurrences of the dataId token found in the expression, + \nwill be replaced with the mapping. This allows the expression of a group external condition to be + \nautomatically customized to the member.")
public class GroupConditionsInfo {
    @ApiModelProperty(value="A list of conditions for a Group Trigger.", position=0, required=true)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Collection<Condition> conditions;
    @ApiModelProperty(value="A map of the dataId tokens in the group conditions to the actual dataIds used for the current member triggers. Can be empty if the group has no existing members.", position=1, required=true)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, Map<String, String>> dataIdMemberMap;

    public GroupConditionsInfo() {
    }

    public GroupConditionsInfo(Condition condition, Map<String, Map<String, String>> dataIdMemberMap) {
        this(new ArrayList<Condition>(1), dataIdMemberMap);
        this.conditions.add(condition);
    }

    public GroupConditionsInfo(Collection<Condition> conditions, Map<String, Map<String, String>> dataIdMemberMap) {
        this.conditions = conditions;
        this.dataIdMemberMap = dataIdMemberMap;
    }

    public Collection<Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(Collection<Condition> conditions) {
        this.conditions = conditions;
    }

    public Map<String, Map<String, String>> getDataIdMemberMap() {
        return this.dataIdMemberMap;
    }

    public void setDataIdMemberMap(Map<String, Map<String, String>> dataIdMemberMap) {
        this.dataIdMemberMap = dataIdMemberMap;
    }

    public String toString() {
        return "GroupConditionsInfo [conditions=" + this.conditions + ", dataIdMemberMap=" + this.dataIdMemberMap + "]";
    }
}

