/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.action;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

@ApiModel(description="Define a time interval (startTime, endTime) used as a constraint for action execution. + \nTime interval can be defined in an absolute or relative expression. + \n + \nAn absolute time interval uses the pattern yyyy.MM.dd[,HH:mm] for startTime and endTime properties. + \nFor example, these representations are valid absolute expressions for time interval: + \n + \n{startTime: \"2016.02.01\", endTime: \"2016.03.01\", relative: false} + \n{startTime: \"2016.02.01,09:00\", endTime: \"2016.03.01,18:00\", relative: false} + \n + \nAbsolute time interval are marked with flag relative set to false. + \nHour and minutes can be optional in absolute format, by default it takes 00:00 value. + \n + \nA relative interval is used for repetitive expressions. + \nIt can be defined an interval between months (i.e. December to March), between days of the week + \n (i.e. Sunday to Friday), between hours and minutes (i.e. 23:00 to 04:30), or a combination of month, + \nday of the week and/or hours and minutes. + \nRelative interval uses the pattern [MMM],[WWW],[HH:mm] where months and days of the week can be used in long or short format. + \nSame pattern should be applied to both startTime and endTime properties. + \nFor example, these representations are valid relative expressions for time interval: + \n + \n{startTime: \"Jul\", endTime: \"Dec\", relative: true} + \n{startTime: \"July\", endTime: \"December\", relative: true} + \n + \nAll dates within July and December months will be valid. + \n + \n{startTime: \"Jul,Mon\", endTime: \"Dec,Fri\", relative: true} + \n{startTime: \"July,Monday\", endTime: \"December,Friday\", relative: true} + \n + \nAll dates within July and December months and within Monday and Friday days are valid. + \nSo, a Sunday day of August will not be valid according previous example. + \n + \n{startTime: \"Jul,Mon,09:00\", endTime: \"Dec,Fri,18:00\", relative: true} + \n{startTime: \"July,Monday\", endTime: \"December,Friday\", relative: true} + \n + \nAll dates within July and December months and within Monday and Friday days and time between 09:00 and18:00 are valid. + \nSo, a Monday day of August at 18:01 will not be valid according previous example. + \n + \n{startTime:\"Monday,09:00\", endTime:\"Friday,18:00\", relative: true} + \n{startTime:\"Mon,09:00\", endTime:\"Fri,18:00\", relative: true} + \n + \nAll dates within Monday and Friday day and time between 09:00 and 18:00 will be valid. + \nSo, a Monday at 18:01 will not be valid according previous example. + \n + \n{startTime:\"July,09:00\", endTime:\"August,18:00\", relative: true} + \n{startTime:\"Jul,09:00\", endTime:\"Aug,18:00\", relative: true} + \n + \nAll dates within July and December months and time between 09:00 and 18:00 are valid. + \nA day of August at 18:01 will not be valid according previous example. + \n + \n{startTime:\"09:00\", endTime:\"18:00\", relative: true} + \n + \nAll times within 09:00 and 18:00 are valid. + \n + \nTimeConstraint inRange property defines whether a given time must fall inside or outside + \nthe defined interval. Setting inRange == true means the constraint will be satisfied if a + \ngiven date is within the interval (taking the limits as inclusive). By setting + \ninRange == false the constraint is satisfied if a given date is outside of the interval. + \nBy default, inRange == true. + \nFor example, + \n + \n{startTime:\"09:00\", endTime:\"18:00\", relative: true, inRange: true} + \n + \nAll times within 09:00 and 18:00 are satisfied by the interval. + \n + \n{startTime:\"09:00\", endTime:\"18:00\", relative: true, inRange: false} + \n + \nAll times from 18:01 to 08:59 are satisfied in the interval. + \n + \nBy default the defined absolute or relative intervals use the default time zone (of the server). + \nThis can be unpredictable unless the server time zone is well known and acceptable.  It is + \nrecommended to explicitly set the time zone for which the TimeConstraint intervals are applicable. + \nThis is done by setting the timeZoneName property. + \nFor example, here is a TimeConstraint for business hours: + \n + \n        {startTime:\"09:00\", endTime:\"18:00\"} + \n + \nIf the server is running in London then this reflects business hours in London. But perhaps the + \nadmins are in New York and the TimeConstraint should actually reflect their local time zone. + \nIn that case use: + \n + \n        {startTime:\"09:00\", endTime:\"18:00\", timeZoneName: \"America/New_York\", relative: true} + \n + \nIt is also possible to use a GMT-relative value: + \n + \n        {startTime:\"09:00\", endTime:\"18:00\", timeZoneName: \"GMT-5:00\", relative: true} + \n")
public class TimeConstraint
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final SimpleDateFormat dateParser = new SimpleDateFormat("yyyy.MM.dd");
    private static final SimpleDateFormat dateTimeParser = new SimpleDateFormat("yyyy.MM.dd,HH:mm");
    @ApiModelProperty(value="Define the start of the time interval. It can be in absolute or relative format.", position=0, required=true)
    @JsonInclude
    private String startTime;
    @ApiModelProperty(value="Define the end of the time interval. It can be in absolute or relative format.", position=1, required=true)
    @JsonInclude
    private String endTime;
    @ApiModelProperty(value="Define if startTime and endTime properties are defined in absolute or relative format.", position=2, example="true")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private boolean relative;
    @ApiModelProperty(value="Indicate if time constraint is satisfied when a given timestamp is inside or outside the interval.", position=3, example="true")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private boolean inRange;
    @ApiModelProperty(value="Indicate the time zone in which the times are expressed. If not specified the server's default time zone is applied. Time zone is expressed in standard Area/Location format. It is recommended to specify the time zone unless you are sure of the server environment.", position=4, required=false)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String timeZoneName;
    @JsonIgnore
    private transient int startMonth = -1;
    @JsonIgnore
    private transient int startDay = -1;
    @JsonIgnore
    private transient int startMinute = -1;
    @JsonIgnore
    private transient int endMonth = -1;
    @JsonIgnore
    private transient int endDay = -1;
    @JsonIgnore
    private transient int endMinute = -1;
    @JsonIgnore
    private transient Date startDate = null;
    @JsonIgnore
    private transient Date endDate = null;
    @JsonIgnore
    private transient TimeZone timeZone;

    public TimeConstraint() {
        this("Jan", "Dec", true, true);
    }

    public TimeConstraint(String startTime, String endTime) {
        this(startTime, endTime, null, true, true);
    }

    public TimeConstraint(String startTime, String endTime, String timeZoneName) {
        this(startTime, endTime, timeZoneName, true, true);
    }

    public TimeConstraint(String startTime, String endTime, boolean relative) {
        this(startTime, endTime, null, relative, true);
    }

    public TimeConstraint(String startTime, String endTime, String timeZoneName, boolean relative) {
        this(startTime, endTime, timeZoneName, relative, true);
    }

    public TimeConstraint(String startTime, String endTime, boolean relative, boolean inRange) {
        this(startTime, endTime, null, relative, inRange);
    }

    public TimeConstraint(String startTime, String endTime, String timeZoneName, boolean relative, boolean inRange) {
        if (this.isEmpty(startTime)) {
            throw new IllegalArgumentException("startTime must be not null");
        }
        if (this.isEmpty(endTime)) {
            throw new IllegalArgumentException("endTime must be not null");
        }
        this.startTime = startTime;
        this.endTime = endTime;
        this.relative = relative;
        this.inRange = inRange;
        this.setTimeZoneName(timeZoneName);
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        if (this.isEmpty(startTime)) {
            throw new IllegalArgumentException("startTime must be not null");
        }
        this.startTime = startTime;
        if (this.relative) {
            this.updateRelative();
        } else {
            this.updateAbsolute();
        }
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        if (this.isEmpty(endTime)) {
            throw new IllegalArgumentException("endTime must be not null");
        }
        this.endTime = endTime;
        if (this.relative) {
            this.updateRelative();
        } else {
            this.updateAbsolute();
        }
    }

    public boolean isRelative() {
        return this.relative;
    }

    public void setRelative(boolean relative) {
        this.relative = relative;
        if (relative) {
            this.updateRelative();
        } else {
            this.updateAbsolute();
        }
    }

    public boolean isInRange() {
        return this.inRange;
    }

    public void setInRange(boolean inRange) {
        this.inRange = inRange;
        if (this.relative) {
            this.updateRelative();
        } else {
            this.updateAbsolute();
        }
    }

    public String getTimeZoneName() {
        return this.timeZoneName;
    }

    public void setTimeZoneName(String timeZoneName) {
        this.timeZoneName = timeZoneName;
        this.timeZone = null == timeZoneName ? TimeZone.getDefault() : TimeZone.getTimeZone(timeZoneName);
        dateParser.setTimeZone(this.timeZone);
        dateTimeParser.setTimeZone(this.timeZone);
        if (this.relative) {
            this.updateRelative();
        } else {
            this.updateAbsolute();
        }
    }

    @JsonIgnore
    public boolean isSatisfiedBy(long timestamp) throws IllegalArgumentException {
        if (this.relative) {
            return this.checkRelative(timestamp);
        }
        return this.checkAbsolute(timestamp);
    }

    private void updateRelative() {
        this.startMonth = -1;
        this.endMonth = -1;
        this.startDay = -1;
        this.endDay = -1;
        this.startMinute = -1;
        this.endMinute = -1;
        String[] start = this.startTime.split(",");
        String[] end = this.endTime.split(",");
        int startFields = start.length;
        if (startFields > 3) {
            throw new IllegalArgumentException("startTime has more than 3 fields");
        }
        int endFields = end.length;
        if (endFields > 3) {
            throw new IllegalArgumentException("endTime has more than 3 fields");
        }
        switch (startFields) {
            case 3: {
                this.startMonth = this.month(start[0]);
                this.startDay = this.day(start[1]);
                this.startMinute = this.minute(start[2]);
                break;
            }
            case 2: {
                this.startMonth = this.month(start[0]);
                this.startDay = this.day(start[0]);
                this.startMinute = this.minute(start[1]);
                break;
            }
            case 1: {
                this.startMonth = this.month(start[0]);
                this.startDay = this.day(start[0]);
                this.startMinute = this.minute(start[0]);
                break;
            }
        }
        switch (endFields) {
            case 3: {
                this.endMonth = this.month(end[0]);
                this.endDay = this.day(end[1]);
                this.endMinute = this.minute(end[2]);
                break;
            }
            case 2: {
                this.endMonth = this.month(end[0]);
                this.endDay = this.day(end[0]);
                this.endMinute = this.minute(end[1]);
                break;
            }
            case 1: {
                this.endMonth = this.month(end[0]);
                this.endDay = this.day(end[0]);
                this.endMinute = this.minute(end[0]);
                break;
            }
        }
        if (this.startMonth == -1 && this.startDay == -1 && this.startMinute == -1) {
            throw new IllegalArgumentException("Bad format on startTime: " + this.startTime);
        }
        if (this.endMonth == -1 && this.endDay == -1 && this.endMinute == -1) {
            throw new IllegalArgumentException("Bad format on endTime: " + this.endTime);
        }
    }

    private boolean isInInterval(int start, int end, int value) {
        if (start <= end) {
            return start <= value && value <= end;
        }
        return start <= value || value <= end;
    }

    private boolean checkRelative(long timestamp) throws IllegalArgumentException {
        Calendar cal = Calendar.getInstance(this.timeZone);
        cal.setTimeInMillis(timestamp);
        if (this.inRange) {
            int month = cal.get(2);
            if (this.startMonth != -1 && this.endMonth != -1 && !this.isInInterval(this.startMonth, this.endMonth, month)) {
                return false;
            }
            int day = cal.get(7);
            if (this.startDay != -1 && this.endDay != -1 && !this.isInInterval(this.startDay, this.endDay, day)) {
                return false;
            }
            int minute = cal.get(11) * 60 + cal.get(12);
            return this.startMinute == -1 || this.endMinute == -1 || this.isInInterval(this.startMinute, this.endMinute, minute);
        }
        int month = cal.get(2);
        if (this.startMonth != -1 && this.endMonth != -1 && !this.isInInterval(this.startMonth, this.endMonth, month)) {
            return true;
        }
        int day = cal.get(7);
        if (this.startDay != -1 && this.endDay != -1 && !this.isInInterval(this.startDay, this.endDay, day)) {
            return true;
        }
        int minute = cal.get(11) * 60 + cal.get(12);
        return this.startMinute != -1 && this.endMinute != -1 && !this.isInInterval(this.startMinute, this.endMinute, minute);
    }

    private int month(String sMonth) {
        if (this.isEmpty(sMonth)) {
            return -1;
        }
        if (sMonth.length() < 3) {
            return -1;
        }
        String prefix = sMonth.substring(0, 3).toLowerCase();
        MONTH m = MONTH.fromString(prefix);
        if (m == null) {
            return -1;
        }
        switch (m) {
            case JANUARY: {
                return 0;
            }
            case FEBRUARY: {
                return 1;
            }
            case MARCH: {
                return 2;
            }
            case APRIL: {
                return 3;
            }
            case MAY: {
                return 4;
            }
            case JUNE: {
                return 5;
            }
            case JULY: {
                return 6;
            }
            case AUGUST: {
                return 7;
            }
            case SEPTEMBER: {
                return 8;
            }
            case OCTOBER: {
                return 9;
            }
            case NOVEMBER: {
                return 10;
            }
            case DECEMBER: {
                return 11;
            }
        }
        return -1;
    }

    private int day(String sDay) {
        if (this.isEmpty(sDay)) {
            return -1;
        }
        if (sDay.length() < 3) {
            return -1;
        }
        String prefix = sDay.substring(0, 3).toLowerCase();
        DAY d = DAY.fromString(prefix);
        if (d == null) {
            return -1;
        }
        switch (d) {
            case SUNDAY: {
                return 1;
            }
            case MONDAY: {
                return 2;
            }
            case TUESDAY: {
                return 3;
            }
            case WEDNESDAY: {
                return 4;
            }
            case THURSDAY: {
                return 5;
            }
            case FRIDAY: {
                return 6;
            }
            case SATURDAY: {
                return 7;
            }
        }
        return -1;
    }

    private int minute(String sTime) {
        if (this.isEmpty(sTime)) {
            return -1;
        }
        int separator = sTime.indexOf(":");
        if (separator < 0) {
            return -1;
        }
        try {
            return Integer.valueOf(sTime.substring(0, separator)) * 60 + Integer.valueOf(sTime.substring(separator + 1));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private boolean checkAbsolute(long timestamp) throws IllegalArgumentException {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timestamp);
        Date timeDate = cal.getTime();
        if (this.inRange) {
            return this.startDate.compareTo(timeDate) <= 0 && this.endDate.compareTo(timeDate) >= 0;
        }
        return this.startDate.compareTo(timeDate) > 0 || this.endDate.compareTo(timeDate) < 0;
    }

    private void updateAbsolute() {
        this.startDate = null;
        this.endDate = null;
        try {
            this.startDate = this.startTime.indexOf(",") == -1 ? dateParser.parse(this.startTime) : dateTimeParser.parse(this.startTime);
            this.endDate = this.endTime.indexOf(",") == -1 ? dateParser.parse(this.endTime) : dateTimeParser.parse(this.endTime);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Bad format on startTime and/or endTime: " + e.getMessage());
        }
    }

    private boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public String toString() {
        return "TimeConstraint[startTime='" + this.startTime + '\'' + ", endTime='" + this.endTime + '\'' + ", relative=" + this.relative + ", inRange=" + this.inRange + ", timeZoneName=" + this.timeZoneName + ", timeZone=" + this.timeZone.toString() + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeConstraint that = (TimeConstraint)o;
        if (this.relative != that.relative) {
            return false;
        }
        if (this.inRange != that.inRange) {
            return false;
        }
        if (this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null) {
            return false;
        }
        return this.endTime != null ? this.endTime.equals(that.endTime) : that.endTime == null;
    }

    public int hashCode() {
        int result = this.startTime != null ? this.startTime.hashCode() : 0;
        result = 31 * result + (this.endTime != null ? this.endTime.hashCode() : 0);
        result = 31 * result + (this.relative ? 1 : 0);
        result = 31 * result + (this.inRange ? 1 : 0);
        return result;
    }

    public static enum DAY {
        SUNDAY("sun"),
        MONDAY("mon"),
        TUESDAY("tue"),
        WEDNESDAY("wed"),
        THURSDAY("thu"),
        FRIDAY("fri"),
        SATURDAY("sat");

        private String day;

        private DAY(String day) {
            this.day = day;
        }

        public String getDay() {
            return this.day;
        }

        public static DAY fromString(String s) {
            if (s == null || s.isEmpty()) {
                return null;
            }
            for (DAY d : DAY.values()) {
                if (!d.getDay().equalsIgnoreCase(s)) continue;
                return d;
            }
            return null;
        }
    }

    public static enum MONTH {
        JANUARY("jan"),
        FEBRUARY("feb"),
        MARCH("mar"),
        APRIL("apr"),
        MAY("may"),
        JUNE("jun"),
        JULY("jul"),
        AUGUST("aug"),
        SEPTEMBER("sep"),
        OCTOBER("oct"),
        NOVEMBER("nov"),
        DECEMBER("dec");

        private String month;

        private MONTH(String month) {
            this.month = month;
        }

        public String getMonth() {
            return this.month;
        }

        public static MONTH fromString(String s) {
            if (s == null || s.isEmpty()) {
                return null;
            }
            for (MONTH m : MONTH.values()) {
                if (!m.getMonth().equalsIgnoreCase(s)) continue;
                return m;
            }
            return null;
        }
    }
}

