/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.condition;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hawkular.alerts.api.model.condition.AvailabilityCondition;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.ConditionEval;
import org.hawkular.alerts.api.model.data.AvailabilityType;
import org.hawkular.alerts.api.model.data.Data;

@ApiModel(description="An evaluation state for availability condition.")
public class AvailabilityConditionEval
extends ConditionEval {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value="Availability condition linked with this state.", position=0)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private AvailabilityCondition condition;
    @ApiModelProperty(value="Availability value used for dataId.", position=1)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private AvailabilityType value;

    public AvailabilityConditionEval() {
        super(Condition.Type.AVAILABILITY, false, 0L, null);
        this.condition = null;
        this.value = null;
    }

    public AvailabilityConditionEval(AvailabilityCondition condition, Data avail) {
        super(Condition.Type.AVAILABILITY, condition.match(AvailabilityType.valueOf(avail.getValue())), avail.getTimestamp(), avail.getContext());
        this.condition = condition;
        this.value = AvailabilityType.valueOf(avail.getValue());
    }

    public AvailabilityCondition getCondition() {
        return this.condition;
    }

    public void setCondition(AvailabilityCondition condition) {
        this.condition = condition;
    }

    public AvailabilityType getValue() {
        return this.value;
    }

    public void setValue(AvailabilityType value) {
        this.value = value;
    }

    @Override
    public String getTenantId() {
        return this.condition.getTenantId();
    }

    @Override
    public String getTriggerId() {
        return this.condition.getTriggerId();
    }

    @Override
    public int getConditionSetSize() {
        return this.condition.getConditionSetSize();
    }

    @Override
    public int getConditionSetIndex() {
        return this.condition.getConditionSetIndex();
    }

    @Override
    public String getLog() {
        return this.condition.getLog(this.value) + ", evalTimestamp=" + this.evalTimestamp + ", dataTimestamp=" + this.dataTimestamp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AvailabilityConditionEval that = (AvailabilityConditionEval)o;
        if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) {
            return false;
        }
        return this.value == that.value;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "AvailabilityConditionEval [condition=" + this.condition + ", value=" + (Object)((Object)this.value) + ", match=" + this.match + ", evalTimestamp=" + this.evalTimestamp + ", dataTimestamp=" + this.dataTimestamp + "]";
    }
}

