/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.condition;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hawkular.alerts.api.json.JacksonDeserializer;
import org.hawkular.alerts.api.model.condition.AvailabilityCondition;
import org.hawkular.alerts.api.model.condition.CompareCondition;
import org.hawkular.alerts.api.model.condition.EventCondition;
import org.hawkular.alerts.api.model.condition.ExternalCondition;
import org.hawkular.alerts.api.model.condition.MissingCondition;
import org.hawkular.alerts.api.model.condition.NelsonCondition;
import org.hawkular.alerts.api.model.condition.RateCondition;
import org.hawkular.alerts.api.model.condition.StringCondition;
import org.hawkular.alerts.api.model.condition.ThresholdCondition;
import org.hawkular.alerts.api.model.condition.ThresholdRangeCondition;
import org.hawkular.alerts.api.model.trigger.Mode;

@ApiModel(description="A base class for condition definition. ", subTypes={AvailabilityCondition.class, CompareCondition.class, EventCondition.class, ExternalCondition.class, MissingCondition.class, NelsonCondition.class, RateCondition.class, StringCondition.class, ThresholdCondition.class, ThresholdRangeCondition.class})
@JsonDeserialize(using=JacksonDeserializer.ConditionDeserializer.class)
public abstract class Condition
implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value="Tenant id owner of this condition.", position=0, required=true, allowableValues="Tenant is overwritten from Hawkular-Tenant HTTP header parameter request")
    @JsonInclude
    protected String tenantId;
    @ApiModelProperty(value="The owning trigger.", position=1, allowableValues="triggerId is set up from REST request parameters")
    @JsonInclude
    protected String triggerId;
    @ApiModelProperty(value="The owning trigger's mode when this condition is active.", position=2, required=true)
    @JsonInclude
    protected Mode triggerMode;
    @ApiModelProperty(value="The type of the condition defined. Each type has its specific properties defined on its subtype of condition.", position=3, required=true)
    @JsonInclude
    protected Type type;
    @ApiModelProperty(value="Number of conditions associated with a particular trigger. This is a read-only value defined by the system.", position=4, required=false)
    @JsonInclude
    protected int conditionSetSize;
    @ApiModelProperty(value="Index of the current condition. This is a read-only value defined by the system.", position=5, required=false)
    @JsonInclude
    protected int conditionSetIndex;
    @ApiModelProperty(value="A composed key for the condition. This is a read-only value defined by the system.", position=6, required=false)
    @JsonInclude
    protected String conditionId;
    @ApiModelProperty(value="Properties defined by the user for this condition.", position=7)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected Map<String, String> context;

    public Condition() {
    }

    public Condition(String tenantId, String triggerId, Mode triggerMode, int conditionSetSize, int conditionSetIndex, Type type) {
        this.tenantId = tenantId;
        this.triggerId = triggerId;
        this.triggerMode = triggerMode;
        this.conditionSetSize = conditionSetSize;
        this.conditionSetIndex = conditionSetIndex;
        this.type = type;
        this.updateId();
    }

    public int getConditionSetIndex() {
        return this.conditionSetIndex;
    }

    public void setConditionSetIndex(int conditionSetIndex) {
        this.conditionSetIndex = conditionSetIndex;
        this.updateId();
    }

    public int getConditionSetSize() {
        return this.conditionSetSize;
    }

    public void setConditionSetSize(int conditionSetSize) {
        this.conditionSetSize = conditionSetSize;
        this.updateId();
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
        this.updateId();
    }

    public Mode getTriggerMode() {
        return this.triggerMode;
    }

    public void setTriggerMode(Mode triggerMode) {
        this.triggerMode = triggerMode;
        this.updateId();
    }

    public String getConditionId() {
        return this.conditionId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
        this.updateId();
    }

    public Map<String, String> getContext() {
        if (null == this.context) {
            this.context = new HashMap<String, String>();
        }
        return this.context;
    }

    public void setContext(Map<String, String> context) {
        this.context = context;
    }

    private void updateId() {
        StringBuilder sb = new StringBuilder(this.tenantId);
        sb.append("-").append(this.triggerId);
        sb.append("-").append(this.triggerMode.name());
        sb.append("-").append(this.conditionSetSize);
        sb.append("-").append(this.conditionSetIndex);
        this.conditionId = sb.toString();
    }

    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.conditionId == null ? 0 : this.conditionId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Condition other = (Condition)obj;
        return !(this.conditionId == null ? other.conditionId != null : !this.conditionId.equals(other.conditionId));
    }

    public String toString() {
        return "Condition [tenantId=" + this.tenantId + "triggerId=" + this.triggerId + ", triggerMode=" + (Object)((Object)this.triggerMode) + ", conditionSetSize=" + this.conditionSetSize + ", conditionSetIndex=" + this.conditionSetIndex + "]";
    }

    @ApiModelProperty(value="Data identifier used for condition evaluation. dataId is used in conjunction with operators defined at subtype condition level.", position=8, required=true, name="dataId")
    public abstract String getDataId();

    public static enum Type {
        AVAILABILITY,
        COMPARE,
        STRING,
        THRESHOLD,
        RANGE,
        EXTERNAL,
        EVENT,
        RATE,
        MISSING,
        NELSON;

    }
}

