/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.condition;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Map;
import org.hawkular.alerts.api.json.JacksonDeserializer;
import org.hawkular.alerts.api.model.condition.AvailabilityConditionEval;
import org.hawkular.alerts.api.model.condition.CompareConditionEval;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.EventConditionEval;
import org.hawkular.alerts.api.model.condition.ExternalConditionEval;
import org.hawkular.alerts.api.model.condition.MissingConditionEval;
import org.hawkular.alerts.api.model.condition.RateConditionEval;
import org.hawkular.alerts.api.model.condition.StringConditionEval;
import org.hawkular.alerts.api.model.condition.ThresholdConditionEval;
import org.hawkular.alerts.api.model.condition.ThresholdRangeConditionEval;

@ApiModel(description="A base class to represent an evaluation state of a specific condition.", subTypes={AvailabilityConditionEval.class, CompareConditionEval.class, EventConditionEval.class, ExternalConditionEval.class, MissingConditionEval.class, RateConditionEval.class, StringConditionEval.class, ThresholdConditionEval.class, ThresholdRangeConditionEval.class})
@JsonDeserialize(using=JacksonDeserializer.ConditionEvalDeserializer.class)
public abstract class ConditionEval
implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value="Result of the condition evaluation.", position=0)
    @JsonIgnore
    protected boolean match;
    @ApiModelProperty(value="Time of condition evaluation.", position=1)
    @JsonInclude
    protected long evalTimestamp;
    @ApiModelProperty(value="Time stamped on the data used in the evaluation.", position=2)
    @JsonInclude
    protected long dataTimestamp;
    @ApiModelProperty(value="The type of the condition eval defined. Each type has its specific properties defined on its subtype of condition eval.", position=3)
    @JsonInclude
    protected Condition.Type type;
    @ApiModelProperty(value="Properties defined by the user at Data level on the dataId used for this evaluation.", position=4)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected Map<String, String> context;

    public ConditionEval() {
    }

    public ConditionEval(Condition.Type type, boolean match, long dataTimestamp, Map<String, String> context) {
        this.type = type;
        this.match = match;
        this.dataTimestamp = dataTimestamp;
        this.evalTimestamp = System.currentTimeMillis();
        this.context = context;
    }

    public boolean isMatch() {
        return this.match;
    }

    public void setMatch(boolean match) {
        this.match = match;
    }

    public long getEvalTimestamp() {
        return this.evalTimestamp;
    }

    public void setEvalTimestamp(long evalTimestamp) {
        this.evalTimestamp = evalTimestamp;
    }

    public long getDataTimestamp() {
        return this.dataTimestamp;
    }

    public void setDataTimestamp(long dataTimestamp) {
        this.dataTimestamp = dataTimestamp;
    }

    public Condition.Type getType() {
        return this.type;
    }

    public void setType(Condition.Type type) {
        this.type = type;
    }

    public Map<String, String> getContext() {
        return this.context;
    }

    public void setContext(Map<String, String> context) {
        this.context = context;
    }

    @JsonIgnore
    public abstract String getTenantId();

    @JsonIgnore
    public abstract String getTriggerId();

    @JsonIgnore
    public abstract int getConditionSetSize();

    @JsonIgnore
    public abstract int getConditionSetIndex();

    @JsonIgnore
    public abstract String getLog();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConditionEval that = (ConditionEval)o;
        if (this.evalTimestamp != that.evalTimestamp) {
            return false;
        }
        if (this.dataTimestamp != that.dataTimestamp) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return !(this.context == null ? that.context != null : !this.context.equals(that.context));
    }

    public int hashCode() {
        int result = (int)(this.evalTimestamp ^ this.evalTimestamp >>> 32);
        result = 31 * result + (int)(this.dataTimestamp ^ this.dataTimestamp >>> 32);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.context != null ? this.context.hashCode() : 0);
        return result;
    }
}

