/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.condition;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.ConditionEval;
import org.hawkular.alerts.api.model.condition.ThresholdCondition;
import org.hawkular.alerts.api.model.data.Data;

@ApiModel(description="An evaluation state for threshold condition.")
public class ThresholdConditionEval
extends ConditionEval {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value="Threshold condition linked with this state.", position=0)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private ThresholdCondition condition;
    @ApiModelProperty(value="Numeric value for dataId used in the evaluation.", position=1)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Double value;

    public ThresholdConditionEval() {
        super(Condition.Type.THRESHOLD, false, 0L, null);
        this.value = Double.NaN;
    }

    public ThresholdConditionEval(ThresholdCondition condition, Data data) {
        super(Condition.Type.THRESHOLD, condition.match(Double.valueOf(data.getValue())), data.getTimestamp(), data.getContext());
        this.condition = condition;
        this.value = Double.valueOf(data.getValue());
    }

    public ThresholdCondition getCondition() {
        return this.condition;
    }

    public void setCondition(ThresholdCondition condition) {
        this.condition = condition;
    }

    public Double getValue() {
        return this.value;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    @Override
    public String getTenantId() {
        return this.condition.getTenantId();
    }

    @Override
    public String getTriggerId() {
        return this.condition.getTriggerId();
    }

    @Override
    public int getConditionSetSize() {
        return this.condition.getConditionSetSize();
    }

    @Override
    public int getConditionSetIndex() {
        return this.condition.getConditionSetIndex();
    }

    @Override
    public String getLog() {
        return this.condition.getLog(this.value) + ", evalTimestamp=" + this.evalTimestamp + ", dataTimestamp=" + this.dataTimestamp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ThresholdConditionEval that = (ThresholdConditionEval)o;
        if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ThresholdConditionEval [condition=" + this.condition + ", value=" + this.value + ", match=" + this.match + ", evalTimestamp=" + this.evalTimestamp + ", dataTimestamp=" + this.dataTimestamp + "]";
    }
}

