/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.trigger;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.dampening.Dampening;
import org.hawkular.alerts.api.model.trigger.Trigger;

@ApiModel(description="Representation of a <<Trigger>> with <<Dampening>> and <<Condition>> objects.")
public class FullTrigger
implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value="The trigger.", position=0, required=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Trigger trigger;
    @ApiModelProperty(value="A list of dampenings linked with the trigger.", position=1, required=false)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<Dampening> dampenings;
    @ApiModelProperty(value="A list of conditions linked with the trigger.", position=2, required=false)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<Condition> conditions;

    public FullTrigger() {
        this(null, null, null);
    }

    public FullTrigger(Trigger trigger, List<Dampening> dampenings, List<Condition> conditions) {
        this.trigger = trigger;
        this.dampenings = dampenings;
        this.conditions = conditions;
        this.checkDampenings();
        this.checkConditions();
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public void setTrigger(Trigger trigger) {
        this.trigger = trigger;
        this.checkDampenings();
        this.checkConditions();
    }

    public List<Dampening> getDampenings() {
        if (this.dampenings == null) {
            this.dampenings = new ArrayList<Dampening>();
        }
        return this.dampenings;
    }

    public void setDampenings(List<Dampening> dampenings) {
        if (dampenings == null) {
            dampenings = new ArrayList<Dampening>();
        }
        this.dampenings = dampenings;
        this.checkDampenings();
    }

    public List<Condition> getConditions() {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        return this.conditions;
    }

    public void setConditions(List<Condition> conditions) {
        if (conditions == null) {
            conditions = new ArrayList<Condition>();
        }
        this.conditions = conditions;
        this.checkConditions();
    }

    public void check() {
        this.checkDampenings();
        this.checkConditions();
    }

    private void checkDampenings() {
        if (!(this.trigger == null || this.isEmpty(this.dampenings) || this.isEmpty(this.trigger.getId()) || this.isEmpty(this.trigger.getTenantId()))) {
            for (Dampening d : this.dampenings) {
                if (this.isEmpty(d.getTenantId()) || !d.getTenantId().equals(this.trigger.getTenantId())) {
                    d.setTenantId(this.trigger.getTenantId());
                }
                if (!this.isEmpty(d.getTriggerId()) && d.getTriggerId().equals(this.trigger.getId())) continue;
                d.setTriggerId(this.trigger.getId());
            }
        }
    }

    private void checkConditions() {
        if (!(this.trigger == null || this.isEmpty(this.conditions) || this.isEmpty(this.trigger.getId()) || this.isEmpty(this.trigger.getTenantId()))) {
            for (Condition c : this.conditions) {
                if (this.isEmpty(c.getTenantId()) || !c.getTenantId().equals(this.trigger.getTenantId())) {
                    c.setTenantId(this.trigger.getTenantId());
                }
                if (!this.isEmpty(c.getTriggerId()) && c.getTriggerId().equals(this.trigger.getId())) continue;
                c.setTriggerId(this.trigger.getId());
            }
        }
    }

    private boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }

    private boolean isEmpty(Collection c) {
        return c == null || c.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FullTrigger that = (FullTrigger)o;
        return this.trigger != null ? this.trigger.equals(that.trigger) : that.trigger == null;
    }

    public int hashCode() {
        return this.trigger != null ? this.trigger.hashCode() : 0;
    }

    public String toString() {
        return "FullTrigger[trigger=" + this.trigger + ", dampenings=" + this.dampenings + ", conditions=" + this.conditions + ']';
    }
}

