/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.api.model.trigger;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.hawkular.alerts.api.model.Severity;
import org.hawkular.alerts.api.model.event.EventType;
import org.hawkular.alerts.api.model.trigger.Match;
import org.hawkular.alerts.api.model.trigger.Mode;
import org.hawkular.alerts.api.model.trigger.TriggerAction;
import org.hawkular.alerts.api.model.trigger.TriggerType;

@ApiModel(description="A Trigger definition. + \n + \nA Trigger can fire an Alert or an Event. + \n + \nTriggers always start in FIRING mode. + \n + \nIf the auto-resolve feature is enabled for the Trigger, then it will switch to AUTORESOLVE mode after firing. + \n + \nWhen the auto-resolve condition set is satisfied, or if the Trigger is reloaded (manually, via edit, or at startup), the trigger returns to FIRING mode. + \n + \nThe mode is also needed when defining a trigger, to indicate the relevant mode for a conditions or dampening definition.")
public class Trigger
implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value="Tenant id owner of this trigger.", position=0, required=true, allowableValues="Tenant is overwritten from Hawkular-Tenant HTTP header parameter request")
    @JsonInclude
    private String tenantId;
    @ApiModelProperty(value="Trigger identifier. Unique within the tenant.", position=1, required=true, example="Auto-generated UUID if not explicitly defined.")
    @JsonInclude
    private String id;
    @ApiModelProperty(value="Trigger name. Used for display.", position=2, required=true)
    @JsonInclude
    private String name;
    @ApiModelProperty(value="Trigger description. Used for display.", position=3)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String description;
    @ApiModelProperty(value="The type of the trigger.", position=4, example="STANDARD")
    @JsonInclude
    private TriggerType type;
    @ApiModelProperty(value="The type of event produced by the trigger.", position=5, example="ALERT")
    @JsonInclude
    private EventType eventType;
    @ApiModelProperty(value="The category of the event produced by the trigger.", position=6)
    @JsonInclude
    private String eventCategory;
    @JsonInclude
    @ApiModelProperty(value="The text of the event produced by the trigger.", position=7, example="If not eventText defined. Description will be used. If not description defined, trigger name will be used.")
    private String eventText;
    @ApiModelProperty(value="Severity of a trigger.", position=8, example="MEDIUM")
    @JsonInclude
    private Severity severity;
    @ApiModelProperty(value="Properties defined by the user for this trigger. Context is propagated on generated Events/Alerts. Context cannot be used as criteria on finder methods.", position=9)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected Map<String, String> context;
    @ApiModelProperty(value="Tags defined by the user for this trigger. A tag is a [name, value] pair.Tags can be used as criteria on finder methods. + \nTag value cannot be null.", position=10)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected Map<String, String> tags;
    @ApiModelProperty(value="A list of links to actions.", position=11)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Set<TriggerAction> actions;
    @ApiModelProperty(value="Disable automatically after firing.", position=12, example="false")
    @JsonInclude
    private boolean autoDisable;
    @ApiModelProperty(value="Enable automatically if disabled and resolved manually.", position=13, example="false")
    @JsonInclude
    private boolean autoEnable;
    @ApiModelProperty(value="Switch to auto-resolve mode after firing.", position=14, example="false")
    @JsonInclude
    private boolean autoResolve;
    @ApiModelProperty(value="Resolve all unresolved alerts when auto-resolve condition-set is satisfied.", position=15, example="false")
    @JsonInclude
    private boolean autoResolveAlerts;
    @ApiModelProperty(value="The policy used for deciding whether the trigger auto-resolved condition-set is satisfied. ALL conditions must evaluate to true or ANY one condition must evaluate to true.", position=16, example="ALL")
    @JsonInclude
    private Match autoResolveMatch;
    @ApiModelProperty(value="Only set for MEMBER triggers, the dataIdMap used when adding the member. It is reused for group condition updates unless a new dataIdMap is provided.", position=17)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected Map<String, String> dataIdMap;
    @ApiModelProperty(value="Only set for MEMBER triggers, the group trigger for which this is a member.", position=18)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String memberOf;
    @ApiModelProperty(value="A enabled trigger is loaded into the engine for data evaluation.", position=19, example="false")
    @JsonInclude
    private boolean enabled;
    @ApiModelProperty(value="The policy used for deciding whether the trigger condition-set is satisfied. ALL conditions must evaluate to true or ANY one condition must evaluate to true.", position=20, example="ALL")
    @JsonInclude
    private Match firingMatch;
    @ApiModelProperty(value="Extended mechanism to match trigger conditions against Data with [source, dataId] identifiers. In this way it is possible to qualify triggers and data with a source such that a trigger only evaluates data having the same source.", position=21)
    @JsonInclude
    String source;
    @JsonIgnore
    private Mode mode;
    @JsonIgnore
    private transient Match match;

    public Trigger() {
        this("defaultTenant", "defaultName");
    }

    public Trigger(String triggerId, String name) {
        this(null, triggerId, name, null);
    }

    public Trigger(String triggerId, String name, Map<String, String> context) {
        this(null, triggerId, name, context);
    }

    public Trigger(String tenantId, String id, String name) {
        this(tenantId, id, name, null, null);
    }

    public Trigger(String tenantId, String id, String name, Map<String, String> context) {
        this(tenantId, id, name, context, null);
    }

    public Trigger(String tenantId, String id, String name, Map<String, String> context, Map<String, String> tags) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Trigger id must be non-empty");
        }
        this.tenantId = tenantId;
        this.id = id;
        this.name = name;
        this.context = context;
        this.tags = tags;
        this.actions = new HashSet<TriggerAction>();
        this.autoDisable = false;
        this.autoEnable = false;
        this.autoResolve = false;
        this.autoResolveAlerts = true;
        this.autoResolveMatch = Match.ALL;
        this.dataIdMap = null;
        this.eventCategory = null;
        this.eventText = null;
        this.eventType = EventType.ALERT;
        this.memberOf = null;
        this.description = null;
        this.enabled = false;
        this.firingMatch = Match.ALL;
        this.type = TriggerType.STANDARD;
        this.source = "_none_";
        this.severity = Severity.MEDIUM;
        this.match = Match.ALL;
        this.mode = Mode.FIRING;
    }

    public static String generateId() {
        return UUID.randomUUID().toString();
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Trigger name must be non-empty.");
        }
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public void setEventType(EventType eventType) {
        if (eventType == null) {
            eventType = EventType.ALERT;
        }
        this.eventType = eventType;
    }

    public String getEventCategory() {
        return this.eventCategory;
    }

    public void setEventCategory(String eventCategory) {
        this.eventCategory = eventCategory;
    }

    public String getEventText() {
        return this.eventText;
    }

    public void setEventText(String eventText) {
        this.eventText = eventText;
    }

    public Map<String, String> getContext() {
        if (null == this.context) {
            this.context = new HashMap<String, String>();
        }
        return this.context;
    }

    public void setContext(Map<String, String> context) {
        if (null == context) {
            context = new HashMap<String, String>();
        }
        this.context = context;
    }

    public void addContext(String name, String value) {
        if (null == name || null == value) {
            throw new IllegalArgumentException("Context must have non-null name and value");
        }
        this.getContext().put(name, value);
    }

    public Map<String, String> getTags() {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        if (null == tags) {
            tags = new HashMap<String, String>();
        }
        this.tags = tags;
    }

    public void addTag(String name, String value) {
        if (null == name || null == value) {
            throw new IllegalArgumentException("Tag must have non-null name and value");
        }
        this.getTags().put(name, value);
    }

    public boolean isAutoDisable() {
        return this.autoDisable;
    }

    public void setAutoDisable(boolean autoDisable) {
        this.autoDisable = autoDisable;
    }

    public boolean isAutoEnable() {
        return this.autoEnable;
    }

    public void setAutoEnable(boolean autoEnable) {
        this.autoEnable = autoEnable;
    }

    public boolean isAutoResolve() {
        return this.autoResolve;
    }

    public void setAutoResolve(boolean autoResolve) {
        this.autoResolve = autoResolve;
    }

    public boolean isAutoResolveAlerts() {
        return this.autoResolveAlerts;
    }

    public void setAutoResolveAlerts(boolean autoResolveAlerts) {
        this.autoResolveAlerts = autoResolveAlerts;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        if (severity == null) {
            severity = Severity.MEDIUM;
        }
        this.severity = severity;
    }

    public Match getFiringMatch() {
        return this.firingMatch;
    }

    public Match getAutoResolveMatch() {
        return this.autoResolveMatch;
    }

    public Set<TriggerAction> getActions() {
        if (this.actions == null) {
            this.actions = new HashSet<TriggerAction>();
        }
        return this.actions;
    }

    public void setActions(Set<TriggerAction> actions) {
        if (actions == null) {
            actions = new HashSet<TriggerAction>();
        }
        this.actions = actions;
    }

    public Map<String, String> getDataIdMap() {
        return this.dataIdMap;
    }

    public void setDataIdMap(Map<String, String> dataIdMap) {
        this.dataIdMap = dataIdMap;
    }

    public void addAction(TriggerAction triggerAction) {
        this.getActions().add(triggerAction);
    }

    public String getMemberOf() {
        return this.memberOf;
    }

    public void setMemberOf(String memberOf) {
        this.memberOf = memberOf;
    }

    @JsonIgnore
    public boolean isGroup() {
        switch (this.type) {
            case GROUP: 
            case DATA_DRIVEN_GROUP: {
                return true;
            }
        }
        return false;
    }

    public TriggerType getType() {
        return this.type;
    }

    public void setType(TriggerType type) {
        if (null == type) {
            type = TriggerType.STANDARD;
        }
        this.type = type;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        if (null == source) {
            source = "_none_";
        }
        this.source = source;
    }

    @JsonIgnore
    public boolean isMember() {
        switch (this.type) {
            case MEMBER: 
            case ORPHAN: {
                return true;
            }
        }
        return false;
    }

    @JsonIgnore
    public boolean isOrphan() {
        return this.type == TriggerType.ORPHAN;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @JsonIgnore
    public boolean isLoadable() {
        return !this.isGroup() && this.enabled;
    }

    @JsonIgnore
    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        this.setMatch(this.mode == Mode.FIRING ? this.getFiringMatch() : this.getAutoResolveMatch());
    }

    @JsonIgnore
    public Match getMatch() {
        return this.match;
    }

    public void setMatch(Match match) {
        this.match = match;
    }

    public void setFiringMatch(Match firingMatch) {
        if (firingMatch == null) {
            firingMatch = Match.ALL;
        }
        this.firingMatch = firingMatch;
        this.setMatch(this.mode == Mode.FIRING ? this.getFiringMatch() : this.getAutoResolveMatch());
    }

    public void setAutoResolveMatch(Match autoResolveMatch) {
        if (autoResolveMatch == null) {
            autoResolveMatch = Match.ALL;
        }
        this.autoResolveMatch = autoResolveMatch;
        this.setMatch(this.mode == Mode.FIRING ? this.getFiringMatch() : this.getAutoResolveMatch());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Trigger trigger = (Trigger)o;
        if (this.id != null ? !this.id.equals(trigger.id) : trigger.id != null) {
            return false;
        }
        return !(this.tenantId == null ? trigger.tenantId != null : !this.tenantId.equals(trigger.tenantId));
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.tenantId != null ? this.tenantId.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Trigger [tenantId=" + this.tenantId + ", id=" + this.id + ", type=" + this.type.name() + ", eventType=" + this.eventType.name() + ", name=" + this.name + ", description=" + this.description + ", eventCategory=" + this.eventCategory + ", eventText=" + this.eventText + ", severity=" + (Object)((Object)this.severity) + ", context=" + this.context + ", actions=" + this.actions + ", autoDisable=" + this.autoDisable + ", autoEnable=" + this.autoEnable + ", autoResolve=" + this.autoResolve + ", autoResolveAlerts=" + this.autoResolveAlerts + ", autoResolveMatch=" + (Object)((Object)this.autoResolveMatch) + ", memberOf=" + this.memberOf + ", dataIdMap=" + this.dataIdMap + ", enabled=" + this.enabled + ", firingMatch=" + (Object)((Object)this.firingMatch) + ", mode=" + (Object)((Object)this.mode) + ", tags=" + this.tags + "]";
    }
}

