/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.bus.listener;

import java.util.Set;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.jms.MessageListener;
import org.hawkular.actions.api.model.ActionPluginMessage;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.bus.log.MsgLogger;
import org.hawkular.bus.common.consumer.BasicMessageListener;
import org.jboss.logging.Logger;

@MessageDriven(messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="destination", propertyValue="HawkularAlertsPluginsQueue")})
public class ActionPluginListener
extends BasicMessageListener<ActionPluginMessage> {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(ActionPluginListener.class);
    @EJB
    DefinitionsService definitions;

    protected void onBasicMessage(ActionPluginMessage msg) {
        block7: {
            this.log.debugf("Message received: [%s]", (Object)msg);
            String op = msg.getOp();
            String notifierType = msg.getActionPlugin();
            if (op == null || op.isEmpty()) {
                this.msgLog.warnActionPluginRegistrationWithoutOp();
            } else if (op.equals("init")) {
                try {
                    if (this.definitions.getActionPlugin(notifierType) == null) {
                        Set properties = msg.getProperties();
                        this.definitions.addActionPlugin(notifierType, properties);
                        this.msgLog.infoActionPluginRegistration(notifierType);
                        break block7;
                    }
                    this.msgLog.warnActionPluginAlreadyRegistered(notifierType);
                }
                catch (Exception e) {
                    this.log.debugf(e.getMessage(), (Object)e);
                    this.msgLog.errorDefinitionsService(e.getMessage());
                }
            } else {
                this.msgLog.warnActionPluginRegistrationWithUnknownOp(notifierType, op);
            }
        }
    }
}

