/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.bus.sender;

import java.util.HashMap;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.TopicConnectionFactory;
import javax.naming.InitialContext;
import org.hawkular.actions.api.model.ActionMessage;
import org.hawkular.alerts.api.model.action.Action;
import org.hawkular.alerts.api.services.ActionListener;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.bus.log.MsgLogger;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.ConnectionContextFactory;
import org.hawkular.bus.common.Endpoint;
import org.hawkular.bus.common.MessageId;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.producer.ProducerConnectionContext;
import org.jboss.logging.Logger;

public class ActionSender
implements ActionListener {
    private final MsgLogger msgLogger = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(ActionSender.class);
    private final String CONNECTION_FACTORY = "java:/HawkularBusConnectionFactory";
    private final String ACTIONS_TOPIC = "HawkularAlertsActionsTopic";
    private final String DEFINITIONS_SERVICE = "java:app/hawkular-alerts-engine/CassDefinitionsServiceImpl";
    private TopicConnectionFactory conFactory;
    private ConnectionContextFactory ccf;
    private ProducerConnectionContext pcc;
    InitialContext ctx;
    DefinitionsService definitions;

    public void process(Action action) {
        try {
            this.init();
            if (this.pcc == null) {
                this.msgLogger.warnCannotConnectToBus();
                return;
            }
            ActionMessage nMsg = new ActionMessage();
            nMsg.setActionId(action.getActionId());
            nMsg.setMessage(action.getMessage());
            if (this.definitions != null) {
                MessageId mid;
                Map properties = this.definitions.getAction(action.getActionId());
                if (properties != null && properties.containsKey("actionPlugin")) {
                    String notifierType = (String)properties.get("actionPlugin");
                    nMsg.setProperties(properties);
                    mid = new MessageProcessor().send(this.pcc, (BasicMessage)nMsg, ActionSender.actionPluginFilter(notifierType));
                } else {
                    mid = new MessageProcessor().send(this.pcc, (BasicMessage)nMsg);
                }
                this.msgLogger.infoSentActionMessage(mid.getId());
            } else {
                this.msgLogger.warnCannotAccessToDefinitionsService();
            }
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            this.msgLogger.errorProcessingAction(e.getMessage());
        }
    }

    private void init() throws Exception {
        if (this.ctx == null) {
            this.ctx = new InitialContext();
        }
        if (this.conFactory == null) {
            this.conFactory = (TopicConnectionFactory)this.ctx.lookup("java:/HawkularBusConnectionFactory");
            this.ccf = new ConnectionContextFactory((ConnectionFactory)this.conFactory);
            this.pcc = this.ccf.createProducerConnectionContext(new Endpoint(Endpoint.Type.TOPIC, "HawkularAlertsActionsTopic"));
        }
        if (this.definitions == null) {
            this.definitions = (DefinitionsService)this.ctx.lookup("java:app/hawkular-alerts-engine/CassDefinitionsServiceImpl");
        }
    }

    private static Map<String, String> actionPluginFilter(String actionPlugin) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("actionPlugin", actionPlugin);
        return map;
    }
}

